;*******************************************************************************
;***************** 134G / 122G Transceiver CONTROL PROGRAM *********************
;*******************************************************************************
;******************************** VK3CV / WQ1S *********************************
;*******************************************************************************
;
#DEFINE	VERSION "240G_001_24F0305"	;BAND_PCB REVISION_YY F DD MM
;
;************************ REVISION HISTORY ************************************
;
;REV 24F0305 FIRST REVISION OF 240G 001 BOARDS
;
;******************************************************************************
;
; SYNTH FREQUENCY DATA IS STORED IN EEPROM , STARTING AT LOCATION 000H , 5 BYTES PER CHANNEL 
;
;**************************** 10 MHz EXTERNAL uP CLOCK ************************
;
		list p=16F877A
;
		include "P16F877A.inc"
;
		ERRORLEVEL 0, -302	;SUPPRESS SFR PAGE SELECT WARNINGS 
;
		__CONFIG 0373AH
;
; ICD debugger reserved resources
;
; Program memory 01F00H - 01FFFH
;
; RAM GP registers 070H, 0F0H, 0170H, 01E5H - 01F0H  
;
;
;	DEFINITIONS
;				
GR1		EQU	071H		;GL0BAL REGISTERS (EXIST IN ALL BANKS)
GR2		EQU	072H
GR3		EQU	073H
DISREG		EQU	074H		;GLOBAL FREQUENCY DISCIPLINING REGISTER
MEMPOINT	EQU	075H		;GLOBAL FLASH MEMORY PAGE POINTER
EEPOINT		EQU	076H		;GLOBAL EEPOINT REGISTER
GFLAG		EQU	077H		;GLOBAL FLAG REGISTER
W_TEMP		EQU	078H
STATUS_TEMP	EQU	079H
PCLATH_TEMP	EQU	07AH
;
;
;DISREG FREQUENCY DISCIPLING DEFINITIONS
ERRCOR		EQU	000H		;0 = NO ERROR, 1 = AN ERROR CORRECTION IS REQUIRED
ERRCORD		EQU	001H		;0 = ERROR CORRECTION IS NEGATIVE , 1 = ERROR CORRECTION IS POSITIVE
EXT10		EQU	002H		;0 = NO EXTERNAL 10MHZ DETECTED , 1 = 10MHZ DETECTED
INTHH		EQU	003H		;0 = NO INTERRUPT, 1 = INTERRUPT HAS OCCURRED
GDIS		EQU	004H		;0 = NO GPS CLOCK DICIPLINING , 1 = GPS CLOCK DISCIPLINING ACTIVE
M10DIS		EQU	005H		;0 = NO 10MHZ DICIPLINING , 1 = 10MHZ DISCIPLINING ACTIVE
TTEN		EQU	006H		;10 MHz CURSOR TOGGLE FLAG
LERRCORD	EQU	007H		;LAST ERROR CORRECTION DIRECTION, SEE ERRCORD
;
;
;GFLAG GLOBAL FLAG DEFINITIONS
TXON		EQU	000H		;0 = NO TX, 1 = TX IS ACTIVE
CWON		EQU	001H		;0 = NO CW KEY, 1 = CW KEY
RXSTAT		EQU	002H		;0 = NOT IN RX STATE , 1 = IN RX STATE
;BIT3		EQU	003H		;SPARE
CURS		EQU	004H		;CURSOR TOGGLE FLAG
LOWDC		EQU	005H		;0 = DCin OK , 1 = DCin IS LOW 
;BIT6		EQU	006H		;SPARE
QUAD		EQU	007H		;0 = QUADRATURE SIDE HIGH , 1 = QUADRATURE SIDE LOW	
;
;
;
R0		EQU	020H		;RAM GENERAL REGISTERS ALL IN BANK 0
R1		EQU	021H
R2		EQU	022H
R3		EQU	023H
R4		EQU	024H
R5		EQU	025H
R6		EQU	026H
R7		EQU	027H
R8		EQU     028H
TEMP		EQU	029H
;
;********** RAM REGISTERS *********** (ALL IN BANK O)
;
COUNT		EQU	02AH		;GENERAL PURPOSE COUNT
SWITCH		EQU	02BH		;CURRENT SWITCH SETTING (CHANNEL NUMBER)
LSWITCH		EQU	02CH		;LAST SWITCH SETTING
REFHV		EQU	02DH		;100MHz REFERANCE DC VOLTAGE HIGH BITS
REFLV		EQU	02EH		;100MHz REFERANCE DC VOLTAGE LOW BITS
VCOHV	 	EQU	02FH		;VCO VOLTAGE HIGH BITS
VCOLV		EQU	030H		;VCO VOLTAGE LOW BITS
DCINHV		EQU	031H		;DC INPUT VOLTAGE HIGH BYTE
DCINLV		EQU	032H		;DC INPUT VOLTAGE LOW BYTE
MORSECH		EQU	033H		;CURRENT MORSE CHARACTER
MORSE1		EQU	034H		;MORSE REGISTER 1
MORSE2		EQU	035H		;MORSE REGISTER 2
MORSE3		EQU	036H		;MORSE REGISTER 3
SYNTHP		EQU	037H		;SYNTHESIZER EEPROM DATA POINTER
COMPOINT	EQU	038H		;RS232 RX DATA BUFFER POINTER
SERTOC		EQU	039H		;RS232 RX COMMAND TIME OUT COUNTER
RTUNEH		EQU	03AH		;REFERANCE TUNE REGISTER HIGH 8 BITS (EEPROM ERTUNEH VALUE)
RTUNEL		EQU	03BH		;REFERANCE TUNE REGISTER LOW 8 BITS (EEPROM ERTUNEL VALUE)
SPIDH		EQU	03CH		;SPI HIGH DATA HOLDING REGISTER
SPIDM		EQU	03DH		;SPI MED DATA HOLDING REGISTER
SPIDL		EQU	03EH		;SPI LOW DATA HOLDING REGISTER
RERROR		EQU	03FH		;REFERANCE ERROR VALUE (1PPS - CCPR1L LOW 5 BITS),(10MHz - TIMER1 LOW 2 BITS)
LASTRERROR	EQU	040H		;LAST REF ERROR VALUE
NERCOUNT	EQU	041H		;NO DISCIPLINING ERROR COUNT 
TCORR		EQU	042H		;TUNE CORRECTION AMOUNT FOR DICIPLINING
LOCKC		EQU	043H		;DISCIPLINING LOCK COUNTER
LOOPC		EQU	044H		;MAIN LOOP COUNTER
TIMER1LL	EQU	045H		;LAST VALUE OF TIMER 1 LOW BITS
SYNTHR0		EQU	046H		;POINTER AND VALUE OF CURRENT CHANNEL EEPROM R0 
LOCKLEDC	EQU	047H		;LOCK LED TEST COUNTER
VPWRH		EQU	048H		;POWER DETECTOR VOLTAGE HIGH BYTE
VPWRL		EQU	049H		;POWER DETECTOR VOLTAGE LOW BYTE
VTEMPH		EQU	04AH		;VCO TEMPERATURE VOLTAGE HIGH BYTE
VTEMPL		EQU	04BH		;VCO TEMPERATURE VOLTAGE LOW BYTE
;
COMMSBUFF0	EQU	050H		;START OF SERIAL COMMS BUFFER
COMMSBUFFE	EQU	06BH		;END OF SERIAL COMMS BUFFER LENGTH = 27 CHAR
;
;END OF RAM IS 06FH IN BANK 0 , 070H - 07FH EXISTS IN ALL BANKS (GLOBAL REGS)
;
;
;
;******************************************************************************
;***************************** FIXED EQUATES **********************************
;******************************************************************************
;
CORTHRESH	EQU	010H		;1 PPS NERCOUNT THRESHOLD TO SWITCH FROM DYNAMIC TO FIXED DICIPLINING CORRECTION MODE
;
CORTHRESH10	EQU	080H		;10MHz NERCOUNT THRESHOLD TO SWITCH FROM DYNAMIC TO FIXED DICIPLINING CORRECTION MODE
;
LOCKLEDTH	EQU	020H		;1 PPS NERCOUNT THRESHOLD TO START INCREMENT OF LED LOCK COUNTER
;
LOCKCNTTH	EQU	010H		;LOCK LED COUNTER THRESHOLD TO TURN ON LOCK LED
;
LOCKLEDMAX	EQU	020H		;MAXIMUM ALLOWED VALUE OF LOCK LED COUNTER 
;
;
;************************* COLD BOOT PROGRAM START ****************************
;
;START AT THE RESET VECTOR
;
		ORG	000H
		NOP		
		GOTO	COLD
;
;****************************** INTERRUPT VECTOR ******************************
;
;INTERRUPT VECTORS TO HERE
;
		ORG	004H
		GOTO	INTSERV		;SERVICE INTERRUPTS
;
;******************************** START OF PROGRAM ****************************
;
COLD		ORG	020H		;START ADDRESS
		NOP
;
;	PORT INITIALIZATION
;
;	PORT A
;
VDC		EQU	000H		;AN0 INPUT ANALOG DC INPUT VOLTAGE 
VCXOTUNE	EQU	001H		;AN1 INPUT ANALOG VCTCXO TUNE VOLTAGE
VPDET		EQU	002H		;AN2 INPUT ANALOG RF POWER DETECTOR
VPLL		EQU	003H		;AN3 INPUT ANALOG PLL VCO ERROR VOLTAGE 
KEYIN		EQU	004H		;INPUT DIGITAL KEY LINE INPUT
VTEMP		EQU	005H		;AN4 INPUT ANALOG RF CHIP TEMPERATURE
;
		BANKSEL	0
       		CLRF	PORTA		;INITIALIZE PORTS AND DIRECTIONS
;
		MOVLW	089H		;SET UP AD INPUT HERE
		MOVWF	ADCON0		;OSC/32 , AN1 SELECTED
;
		BANKSEL	ADCON1
		MOVLW	002H		;LEFT JUSTIFIED, 5 x ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
;
		MOVLW	B'11111111'	;PORT A DIRECTIONS 
		MOVWF	TRISA		
		BANKSEL 0		;BACK TO REGISTER BANK 0
		CLRF	PORTA		;PORT A ALL OUTPUT REGISTERS (NOT USED) SET LOW 
;
;	PORT B
;
GPSTXD		EQU	000H		;INPUT DIGITAL GPS TX DATA (INT)
CH0		EQU	001H		;INPUT DIGITAL SWITCH 1
CH1		EQU	002H		;INPUT DIGITAL SWITCH 2
CH2		EQU	003H		;INPUT DIGITAL SWITCH 4
CH3		EQU	004H		;INPUT DIGITAL SWITCH 8
VMIC		EQU	005H		;OUTPUT DIGITAL MIC AMP ENABLE
;ICD		EQU	006H		;RESERVED FOR ICD
;ICD		EQU	007H		;RESERVED FOR ICD
;
		CLRF	PORTB
		BANKSEL	TRISB
		MOVLW	B'11011111'     ;PORT B DIRECTIONS
		MOVWF	TRISB		
		BCF	OPTION_REG,7	;ENABLE PORT B WEAK PULLUPS
       		BANKSEL	0
		MOVLW	B'00000000'     ;PORT B INITIAL LEVELS
		MOVWF	PORTB		
;
;	PORT C	
;
EXT10M		EQU	000H		;INPUT DIGITAL EXTERNAL 10MHZ INPUT
FMTONE		EQU	001H		;OUTPUT DIGITAL PWM FM TX TONE GENERATION
PPS		EQU	002H		;INPUT DIGITAL 1PPS
RFCLK		EQU	003H		;OUTPUT DIGITAL PLL SPI CLOCK (LED1)
RFMUX		EQU	004H		;INPUT DIGITAL PLL MUX
RFDATA		EQU	005H		;OUTPUT DIGITAL PLL SPI DATA (LED2)
TXD		EQU	006H		;OUTPUT RS232 TX DATA
RXD		EQU	007H		;INPUT RS232 RX DATA
;
;
 		CLRF	PORTC
		BANKSEL	TRISC
		MOVLW	B'10010101'     ;PORT C DIRECTIONS 
		MOVWF	TRISC		
       	 	BANKSEL	0
		MOVLW	B'00001000'     ;PORT C INITIAL LEVELS (LED ON)
		MOVWF	PORTC		
;
;	PORT D
;
GPSRXD		EQU	000H		;OUTPUT DIGITAL GPS MODULE RX DATA IN
RCP		EQU	001H		;OUTPUT DIGITAL VCO RANGE 1=45GHZ / 0=23GHZ
VCOVTUNEC	EQU	002H		;OUTPUT DIGITAL VCO COARSE TUNE
IQS		EQU	003H		;OUTPUT QUADRATURE COMBINER SELECT, HIGH SIDE L.O. = 1 / LOW SIDE L.O. = 0
PTTIN		EQU	004H		;INPUT DIGITAL PTT INPUT
OL1		EQU	005H		;OUTPUT DIGITAL OPTION LED 1
SIDETONE	EQU	006H		;OUTPUT DIGITAL AUDIO SIDETONE
OL2		EQU	007H		;OUTPUT DIGITAL OPTION LED 2
;
		CLRF	PORTD
		BANKSEL	TRISD
		MOVLW	B'00010000'	;PORT D DIRECTIONS 
       	 	MOVWF	TRISD
		BANKSEL	0
		MOVLW	B'10101001'	;PORT D INITIAL LEVELS (RF CHIP CONTROL LINES)
		MOVWF	PORTD
;
;	PORT E
;
RFLE		EQU	000H		;OUTPUT RF CHIP LATCH ENABLE
DLD		EQU	001H    	;INPUT DIGITAL LOCK DETECT
DACSTB		EQU	002H    	;OUTPUT DIGITAL DAC STROBE
;
		CLRF	PORTE
		BANKSEL	TRISE
		MOVLW	B'00000010'	;PORT E DIRECTIONS
		MOVWF	TRISE           
		BANKSEL	0
		MOVLW	B'00000101'	;PORT E INITIAL LEVELS
		MOVWF	PORTE
;
;
;	COMMS PORT CONFIG
;
		BANKSEL	TXSTA
		MOVLW	B'00100110'	;TX MODE: 8 BITS, ASYNC, HIGH SPEED
		MOVWF	TXSTA		;SET MODE
		BANKSEL	RCSTA
		MOVLW	B'10010000'	;RX MODE 8 BITS, ASYNC, RX ENABLED
		MOVWF	RCSTA		;SET MODE
		MOVLW	D'64'		;SET BAUD RATE 	9600 Bd D64
					;	       56000 Bd D10
		BANKSEL	SPBRG
		MOVWF	SPBRG		;LOAD BAUD RATE
		BANKSEL	0
;
;
;	TIMER 2 SET UP FOR COMPARISON OF EXT 10MHZ, RUN ON OSC/4 INTERNAL CLOCK
;
		BANKSEL	T2CON
		MOVLW	B'00000100'	;1:1 PRE SCALE, RUN TIMER 2
		MOVWF	T2CON		
		BANKSEL	0
;
;
;	REFERANCE FREQUENCY DISCIPLINING CONFIG
;
		MOVLW	002H
		MOVWF	LASTRERROR	;INITIALIZE LAST ERROR VALUE TO DUMMY VALUE
		MOVLW	0FFH
		MOVWF	NERCOUNT	;INITIALIZE NO ERROR COUNT
		MOVLW	001H
		MOVWF	TCORR		;INITIALIZE TUNE CORRECTION VALUE
;
;******************** START OF MAIN PROGRAM *************************
START		NOP
		CLRF	LOCKLEDC	;CLEAR LOCK LED COUNTER
		CLRF	LOCKC		;CLEAR DISCIPLINING LOCK COUNTER
		CLRF	GFLAG		;CLEAR FLAG REGISTER, NO TX , NO CW KEY, NO RX STATE
		CLRF	DISREG		;CLEAR FREQUENCY DISCIPLINING REGISTER
		CLRF	LOOPC		;CLEAR LOOP COUNTER
		CALL	LEDRED
;
		CALL	TSETUP10	;SET UP TIMER 1 TO ACCEPT 10MHZ EXTERNAL INPUT
		MOVFW	TMR1L		;GET TIMER 1 AND ADD BOTH REGISTERS
		ADDWF	TMR1H,W
		MOVWF	TIMER1LL	;STORE
;
		CALL	WAITONE
		BCF	PORTD,RCP	;TUNING RANGE TO LOW (23GHZ)
		CALL	SYNTHINIT	;INITIALIZE SYNTHESIZER CHIP
;
		CALL	PRBOOT		;PRINT BOOT UP STRING
		CALL	LEDGRN
		CALL	WAITONE
		BCF	PORTD,OL1	;TURN OPTION LED 1 OFF
		BCF	PORTD,OL1
		BCF	PORTD,OL2	;TURN OPTION LED 2 OFF
		BCF	PORTD,OL2
;
		MOVFW	TMR1L
		ADDWF	TMR1H,W
		SUBWF	TIMER1LL,W	;CHECK IF DIFFERENT
		BTFSC	STATUS,Z	;IF DIFFERENT THEN 10MHZ IS PRESENT
		GOTO	ONEPPS		;SAME SO DEFAULT TO 1PPS DICIPLINING
;
		BSF	DISREG,EXT10	;SET FLAG TO SHOW EXTERNAL 10 MHZ IS PRESENT	
		BANKSEL	PIR1		;SET UP TIMER 1 OVERFLOW INTERRUPTS
		BCF	PIR1,TMR1IF	;RESET INT FLAG				
		BANKSEL	PIE1
		BSF	PIE1,TMR1IE	;ENABLE TIMER 1 INT
		BANKSEL	0
		GOTO	TIMEROK
;
ONEPPS		CALL	TSETUP1		;SET UP TIMER 1 FOR 1 PPS USE
;		
		BCF	DISREG,EXT10	;CLEAR FLAG TO SHOW 1 PPS DEFAULT
		BANKSEL	PIR1		;CLEAR CCP1 INTERRUPT FLAG AND ENABLE INTERRUPTS
		BCF	PIR1,CCP1IF
		BANKSEL	PIE1
		BSF	PIE1,CCP1IE	;ENABLE CCP1 INT
		BANKSEL	0
;
TIMEROK		CALL	LBEEP
		CALL	GETSWITCH	;GET STARTING CHANNEL SWITCH SETTING
;
		MOVLW	LOW ERTUNEL	;GET INITIAL DAC REF TUNE VALUES FROM EEPROM
		CALL	READEE
		MOVWF	RTUNEL
		MOVLW	LOW ERTUNEH
		CALL	READEE
		MOVWF	RTUNEH
		CALL	SPIWR		;WRITE INITIAL DAC DATA TO TUNE REFERANCE
;
		BSF	INTCON,PEIE	;ENABLE PERIPHERAL INTERRUPTS
		BSF	INTCON,GIE	;ALL GOOD TO GO
;
;************************** MAIN PROGRAM LOOP *********************************
;
MAIN		INCF	LOOPC,F		;INCREMENT MAIN LOOP COUNTER EACH TIME
		BTFSC	DISREG,ERRCOR	;CHECK IF DISCIPLINING CORRECTION IS REQUIRED
		CALL	DISCORR		;DO DISCIPLINING CORRECTION
		BTFSS	PORTC,RFMUX	;CHECK IF PLL LOCKED		
		CALL	PLLERR
		BTFSS	PORTD,PTTIN	;CHECK IF TX REQUESTED
		GOTO	MAYBTXAU
		BTFSS	PORTA,KEYIN	;CHECK IF CW REQUESTED
		GOTO	CWKEY		;MUST BE CW TX
;
RXACTIVE	BTFSS	GFLAG,RXSTAT	;CHECK IF FIRST TIME THROUGH
		CALL	SYNTHRX		;PROGRAM SYNTH IF FIRST TIME HERE
		CALL	LEDGRN		;PUT GREEN LED ON
		BSF	GFLAG,RXSTAT	;SHOW RX STATE
		BCF	GFLAG,TXON	;NO TX ACTIVITY SO CLEAR FLAGS
		BCF	GFLAG,CWON
		BCF	PORTB,VMIC	;TURN OFF MIC AMP
		BCF	PORTB,VMIC
		GOTO	CHKCH		;CONTINUE LOOP
;
MAYBTXAU	BCF	GFLAG,RXSTAT	;SHOW NOT IN RX STATE
		BTFSS	PORTA,KEYIN	;MAYBE AUDIO SO CHECK IF KEY ALSO
		GOTO	BEACONFM	;BOTH SO BEACON MODE
;
;TX FM AUDIO MODE
;
		BCF	GFLAG,CWON	;AUDIO TX STATE SO CLEAR CW FLAG	
		BCF	GFLAG,RXSTAT	;SHOW NOT RX STATE
		BTFSC	GFLAG,TXON	;CHECK IF FIRST TIME		
		GOTO	TXSLOP		;TX ALREADY ON SO CONTINUE
		BSF	GFLAG,TXON	;FIRST TIME THROUGH SO PROG SYNTH
		CALL	SYNTHRX
;
TXSLOP		BSF	PORTB,VMIC	;TURN ON MIC AMP
		BSF	PORTB,VMIC
		CALL	LEDRED		;PUT RED LED ON
		GOTO	CHKCH		;CONTINUE LOOP
;
BEACONFM	BTFSC	PORTB,CH0	;CHECK IF CW BEACON OR FM BEACON MODE
		GOTO	BEACONCW	;DETERMINED BY STATE OF A/B CHANNEL SWITCH
		BCF	PORTB,VMIC
		BCF	PORTB,VMIC	;MAKE SURE MIC IS OFF
		CALL	MORSEIDENT	;SEND MORSE IDENT
		CALL	LEDRED
		CALL	WAIT
		CALL	GETDC		;CHECK DC EVERY LOOP IN THIS MODE
		CALL	CARRIER		;SEND CARRIER BETWEEN IDENTS (JUST A LONG DELAY)
;
		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
		CALL	GETVPWR		;GET RF CHIP RF POWER VOLTAGE
		CALL	GETVTEMP	;GET RF CHIP TEMPERATURE VOLTAGE	
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS EVERY LOOP
		GOTO	CHKCH		;CONTINUE LOOP
;
BEACONCW	BCF	PORTB,VMIC
		BCF	PORTB,VMIC	;MAKE SURE MIC IS OFF
		CALL	MORSEIDENT	;SEND CW MORSE IDENT
		CALL	WAIT
		CALL	GETDC		;CHECK DC EVERY LOOP IN THIS MODE
		CALL	SYNTHTX		;PUT ON CW CARRIER
		CALL	LEDRED
		CALL	CARRIER		;SEND CARRIER BETWEEN IDENTS (JUST A LONG DELAY)
		CALL	SYNTHRX		;BACK TO RX AFTER CARRIER
		CALL	LEDGRN
		CALL	WAIT
		CALL	WAIT		;SMALL SPACE BEFORE NEXT IDENT 
;
		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
		CALL	GETVPWR		;GET RF CHIP RF POWER VOLTAGE
		CALL	GETVTEMP	;GET RF CHIP TEMPERATURE VOLTAGE
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS EVERY LOOP
		GOTO	CHKCH		;CONTINUE LOOP
;
CWKEY		BCF	GFLAG,RXSTAT	;SHOW NOT IN RX STATE
		BCF	GFLAG,TXON	;CW STATE SO CLEAR TX FLAG 
		BCF	GFLAG,RXSTAT	;SHOW NOT RX STATE
;
		BTFSC	PORTB,CH0	;CHECK IF CW OR FM MODE REQUIRED
		GOTO	CWKEYCAR	;GOTO CW CARRIER ONLY MODE

		BTFSC	GFLAG,CWON	;CHECK IF FIRST TIME
		GOTO	CWLOP
		BSF	GFLAG,CWON	;FIRST TIME THROUGH SO PROG SYNTH
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;LOW Z SIDETONE
		BCF	TRISC,FMTONE
		BANKSEL	0
		CALL	SYNTHRX		;STAY ON RX FREQ IN THIS MODE
;
CWLOP		CALL	LEDRED
		BTFSS	PORTC,FMTONE	;TOGGLE FMTONE AND SIDETONE TO GENERATE FM CW AUDIO
		GOTO	CWLOPT	
		BCF	PORTC,FMTONE
		BCF	PORTD,SIDETONE
		GOTO	CWLT
CWLOPT		BSF	PORTC,FMTONE
		BSF	PORTD,SIDETONE
;
CWLT		BTFSC	PORTA,KEYIN	;CHECK IF STILL KEYED
		GOTO	ENDCW		;STAY IN LOOP UNTIL RELEASED
		BTFSS	PORTD,PTTIN	;CHECK THAT PTT IS NOT ASSERTED
		GOTO	ENDCW		;PTT ASSERTED SO BEACON MODE IS REQUESTED
		CALL	CWTDEL		;CW TONE DELAY ROUTINE	
		GOTO	CWLOP
;
ENDCW		NOP
		BANKSEL	TRISD
		BSF	TRISD,SIDETONE	;HI Z FMTONE AND SIDETONE
		BSF	TRISC,FMTONE
		BANKSEL	0
		GOTO	CHKCH
;
CWKEYCAR	BTFSC	GFLAG,CWON	;CHECK IF FIRST TIME
		GOTO	CWLOPCAR
		BSF	GFLAG,CWON	;FIRST TIME THROUGH SO PROG SYNTH
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;LOW Z SIDETONE
		BANKSEL	0
		CALL	SYNTHTX		;CHANGE TO TX FREQ IN THIS MODE
;
CWLOPCAR	CALL	LEDRED
		BTFSS	PORTD,SIDETONE	;TOGGLE SIDETONE TO GENERATE CW AUDIO
		GOTO	CWLOPTCAR	
		BCF	PORTD,SIDETONE
		GOTO	CWLTCAR
CWLOPTCAR	BSF	PORTD,SIDETONE
;
CWLTCAR		BTFSC	PORTA,KEYIN	;CHECK IF STILL KEYED
		GOTO	ENDCWCAR	;STAY IN LOOP UNTIL RELEASED
		BTFSS	PORTD,PTTIN	;CHECK THAT PTT IS NOT ASSERTED
		GOTO	ENDCWCAR	;PTT ASSERTED SO BEACON MODE IS REQUESTED
		CALL	CWTDEL		;CW TONE DELAY ROUTINE	
		GOTO	CWLOPCAR
;
ENDCWCAR	NOP
		BANKSEL	TRISD
		BSF	TRISD,SIDETONE	;HI Z FSK AND SIDETONE
		BANKSEL	0
;
CHKCH		CALL	GETSWITCH	;CHECK SWITCH AND CONTINUE LOOP
		MOVFW	LSWITCH
		SUBWF	SWITCH,W
		BTFSC	STATUS,Z	;CHECK FOR CHANNEL CHANGE
		GOTO	NOCH	
		MOVFW	SWITCH
		MOVWF	LSWITCH		;UPDATE LAST SWITCH
		CALL	SYNTHRX		;UPDATE SYNTHESIZER
		CALL	PRBOOT		;UPDATE BOOT UP HEADER
		CLRF	GFLAG		;CLEAR STATE FLAG TO UPDATE LEDS ETC
;
NOCH		MOVFW	LOOPC		;GET LOOP COUNTER
		ANDLW	B'01111111'	;MASK TO SET RATE
		BTFSS	STATUS,Z
		GOTO	EVERYL		;GET DC EVERY N LOOPS				
		CALL	GETDC
;
		BCF	PORTD,OL1	;TURN OFF DICIPLINING LED BOTH IN 1PPS OR 10MHZ DICIPLINING MODES

;
EVERYL		CALL	CHKCOMMS	;CHECK IF RS232 COMMAND RECEIVED
;
		CALL	GETREF		;GET REFERANCE TUNE VOLTAGE
;		
		CALL	GETVCO		;GET VCO TUNE VOLTAGE
;
		CALL	GETVPWR		;GET RF CHIP RF POWER VOLTAGE
;
		CALL	GETVTEMP	;GET RF CHIP TEMPERATURE VOLTAGE
;
		MOVFW	LOOPC
		BTFSS	STATUS,Z	;PRINT STATUS EVERY 256 TIMES THROUGH MAIN LOOP
		GOTO	MAIN
;
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS
;
		CALL	LOCKLED		;SET STATE OF DISCIPLINING LOCK LED OL2
		GOTO	MAIN
;
;********************************** READ SWITCH *******************************
;
GETSWITCH	RRF	PORTB,W
		MOVWF	SWITCH
		COMF	SWITCH,W
		ANDLW	B'00001111'	;MASK OFF UNUSED BITS
		MOVWF	SWITCH
		RETURN
;
;******************* FREQUENCY DISCIPLINING UPDATE ROUTINE ******************** 
;
DISCORR		MOVLW	LOW ERTUNEL
		MOVWF	EEPOINT
		MOVFW	RTUNEL
		CALL	EEWRITE		;UPDATE REF TUNE VOLTAGE LOW BITS
		MOVLW	LOW ERTUNEH
		MOVWF	EEPOINT
		MOVFW	RTUNEH
		CALL	EEWRITE		;UPDATE REF TUNE VOLTAGE HIGH BITS
		CALL	SPIWR		;UPDATE DAC REFERENCE TUNE VALUES		
		BCF	DISREG,ERRCOR
		BCF	DISREG,ERRCORD	;CLEAR DISCIPLINING ERROR REGISTER 
		RETURN
;
;*********************************** LED CONTROL ******************************
;
;LED TO GREEN
;
LEDGRN		BSF	PORTC,3
		BSF	PORTC,3
		BCF	PORTC,5
		BCF	PORTC,5
		RETURN
;
;LED TO RED
;
LEDRED		BCF	PORTC,3
		BCF	PORTC,3
		BSF	PORTC,5
		BSF	PORTC,5
		RETURN
;
;LED OFF
;
LEDOFF		BCF	PORTC,3
		BCF	PORTC,3
		BCF	PORTC,5
		BCF	PORTC,5
		RETURN
;
;OL2 DICIPLINING LOCK LED CONTROL 
;
LOCKLED		INCF	LOCKLEDC,F
		MOVFW	LOCKLEDC
		ANDLW	B'00000011'
		BTFSS	STATUS,Z	;CHECK LED EVERY 4 LOOPS
		RETURN
;
		BCF	PORTD,OL2	;DEFAULT OL2 LOCK LED TO OFF
;		
		BTFSS	DISREG,INTHH	;CHECK IF INTERRUPT HAS OCCURRED	
		GOTO	LLLEND		;NO SO END AND LEAVE LED OFF
;
		BTFSS	DISREG,EXT10	;CHECK IF 1PPS OR 10MHz IS USED
		GOTO	LOCK1PPS
;
LOCK10M		COMF	NERCOUNT,W	
		BTFSC	STATUS,Z	;CHECK IF NERCOUNT IS 0FFH
		GOTO	M10MER
		MOVFW	LOCKC
		BTFSC	STATUS,Z	;CHECK IF LOCKC IS ZERO	
		GOTO	M10MER
		DECF	LOCKC,F		;DECREMENT LOCK COUNTER IF NERCOUNT BELOW OFFH
		GOTO	LLEND
;
M10MER		INCF	LOCKC,W
		SUBLW	LOCKLEDTH	;ONLY INCEMENT IF NOT AT LOCKLEDTH YET
		BTFSC	STATUS,C
		INCF	LOCKC,F		;INC LOCKC
		GOTO	LLEND
;
LOCK1PPS	MOVFW	NERCOUNT
		SUBLW	LOCKCNTTH	;CHECK IF ABOVE OR BELOW LOCK COUNT THRESHOLD
		BTFSS	STATUS,C
		GOTO	LOCK1PPSA	;ABOVE THRESHOLD
LOCK1PPSB	MOVFW	LOCKC		;BELOW THRESHOLD
		BTFSS	STATUS,Z	;CHECK IF AT ZERO, IF YES, DON'T DEC REGISTER
		DECF	LOCKC,F
		GOTO	LLEND		;NOT ABOVE THRESHOLD SO RETURN WITH LED OFF
;
LOCK1PPSA	INCF	LOCKC,W		;DON'T ALLOW INC OF LOCKC PAST LOCKLEDMAX
		SUBLW	LOCKLEDMAX
		BTFSC	STATUS,C
		INCF	LOCKC,F
;
LLEND		MOVFW	LOCKC
		SUBLW	LOCKCNTTH	;LOCK DECISION THRESHOLD
		BTFSS	STATUS,C
		BSF	PORTD,OL2	;SET LED TO ON IF ABOVE THRESHOLD
LLLEND		BCF	DISREG,INTHH	;CLEAR INTERRUPT FLAG
		RETURN
;
;***************************** SYNTHESIZER ROUTINES ***************************
;
;PROGRAM SYNTHESIZER
;
SYNTHTX		CALL	SYNTHRL		;LOAD FREQ SYNTH DATA
		MOVLW	005H
		ADDWF	SYNTHP,F	;ADD TX OFFSET	
		MOVFW	SYNTHP
		MOVWF	SYNTHR0		;STORE POINTER TO R0
		INCF	SYNTHP,F	;POINT TO R1 VALUES	
		CALL	SYNTHFQ		;SEND (R1) TX FREQ DATA TO SYNTH , ALSO INCREMENTS TO NEXT POINTER LOCATION	
		BCF	PORTE,RFLE	;SYNTH LATCH ENABLE LOW TO START SENDING R0 VALUES
		BCF	PORTE,RFLE	
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		MOVLW	000H
		CALL	SYNTHSEND
		MOVLW	000H
		CALL	SYNTHSEND
		MOVLW	004H
		CALL	SYNTHSEND	;SEND COMMON VALUES OF R0 TO SYNTH CHIP
		MOVFW	SYNTHR0
		CALL	READEE		;GET R0 DATA, RESULT IN WREG
		MOVWF	SYNTHR0
		ANDLW	00FH		;MASK OFF TOP BITS
		MOVWF	R0
		SWAPF	R0,F
		MOVFW	R0
		CALL	SYNTHSEND
		BSF	PORTE,RFLE	;SYNTH LATCH ENABLE HIGH TO LATCH VALUES
		BSF	PORTE,RFLE
;
		BCF	PORTD,IQS
		BTFSC	SYNTHR0,7	;CHECK IF HIGH OR LOW SIDE QUADRATURE REQUIRED	
		BSF	PORTD,IQS
;
		BCF	GFLAG,QUAD	;SET QUAD BIT IN GFLAG REGISTER
		BTFSC	SYNTHR0,7
		BSF	GFLAG,QUAD
;	
		BSF	PORTD,VCOVTUNEC
		BTFSS	SYNTHR0,2	;CHECK IF LOW OR HIGH BAND FROM MSB OF SYTH DATA
		BCF	PORTD,VCOVTUNEC
;
;TEST
;
		BTFSS	PORTC,RFMUX
		GOTO	TXLOCKER	;RE-BOOT ON TX LOCK ERROR
;
		RETURN
;
;
TXLOCKER	NOP
		BANKSEL	0
		CALL	LEDRED
		CALL	WAITONE
		GOTO	MAIN		;RE-BOOT AT START OF MAIN LOOP
;
;
SYNTHRX		CALL	SYNTHRL		;LOAD SYNTH FREQ DATA 
		MOVFW	SYNTHP		
		MOVWF	SYNTHR0		;SAVE POINTER TO R0
		INCF	SYNTHP,F	;POINT TO R1 VALUES
		CALL	SYNTHFQ		;SEND (R1) RX FREQ DATA TO SYNTH , ALSO INCREMENTS TO NEXT POINTER LOCATION
		BCF	PORTE,RFLE	;SYNTH LATCH ENABLE LOW TO START SENDING R0 VALUES
		BCF	PORTE,RFLE	
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		MOVLW	000H
		CALL	SYNTHSEND
		MOVLW	000H
		CALL	SYNTHSEND
		MOVLW	004H
		CALL	SYNTHSEND	;SEND COMMON VALUES OF R0 TO SYNTH CHIP
		MOVFW	SYNTHR0
		CALL	READEE		;GET R0 DATA, RESULT IN WREG
		MOVWF	SYNTHR0		;SAVE R0 DATA
		ANDLW	00FH		;MASK OFF TOP BITS
		MOVWF	R0
		SWAPF	R0,F
		MOVFW	R0
		CALL	SYNTHSEND
		BSF	PORTE,RFLE	;SYNTH LATCH ENABLE HIGH TO LATCH VALUES
		BSF	PORTE,RFLE
;
		BCF	PORTD,IQS
		BTFSC	SYNTHR0,7	;CHECK IF HIGH OR LOW SIDE QUADRATURE REQUIRED	
		BSF	PORTD,IQS
;
		BCF	GFLAG,QUAD	;SET QUAD BIT IN GFLAG REGISTER
		BTFSC	SYNTHR0,7
		BSF	GFLAG,QUAD
;
		BSF	PORTD,VCOVTUNEC
		BTFSS	SYNTHR0,2	;CHECK IF LOW OR HIGH BAND FROM MSB OF SYTH DATA
		BCF	PORTD,VCOVTUNEC
;
		RETURN
;
;LOAD SYNTH FREQUENCY REGISTER FROM TABLE WITH CORRECT OFFSET
;
SYNTHRL		MOVLW	LOW FREQ0	;POINT TO START OF FREQUENCY TABLE DATA 
		MOVWF	SYNTHP		;LOAD POINTER
;
		MOVFW	SWITCH		;GET CHANNEL NUMBER
		MOVWF	R0		;SWITCH TEMP STORE
		BCF	STATUS,C
		RLF	R0,F		;MULTIPLY X 5 TO GET CHANNEL OFFSET
		BCF	STATUS,C
		RLF	R0,F
		BCF	STATUS,C
		ADDWF	R0,F		;ADD ONE MORE SWITCH VALUE
		MOVFW	R0
		ADDWF	SYNTHP,F	;UPDATE POINTER TO CORRECT TABLE POSITION
		RETURN
;
;POWER UP SYNTH AND INITIALIZE
;
SYNTHINIT	MOVLW	LOW SYNTHEN	;POINT TO START OF SYNTH ENABLE TABLE
		MOVWF	SYNTHP		;LOAD POINTER
		MOVLW	D'14'		;14 SYNTH REGISTERS TO BE LOADED
		MOVWF	R3		;USE R3 AS COUNTER
SYNINITL	CALL	SYNTHREG	;LOAD SYNTH REG (R13 FIRST THEN ENDING IN R0)
		DECFSZ	R3,F
		GOTO	SYNINITL		
		RETURN
;
;POWER DOWN SYNTH AND RESET
;
SYNTHOFF	MOVLW	LOW SYNTHDIS	;POINT TO START OF SYNTH DISSABLE TABLE
		MOVWF	SYNTHP		;LOAD POINTER
		MOVLW	D'14'		;14 SYNTH REGISTERS TO BE LOADED
		MOVWF	R3		;USE R3 AS COUNTER
SYNOFFL		CALL	SYNTHREG	;LOAD SYNTH REG (R13 FIRST THEN ENDING IN R0)
		DECFSZ	R3,F
		GOTO	SYNOFFL		
		RETURN
;
;SEND INITIALIZATION SYNTH DATA TO CHIP
;
SYNTHREG	MOVLW	004H		;LOAD EACH SYTHESIZER REGISTER IN TURN WITH 4 BYTES
		MOVWF	R0		;LOAD COUNTER WITH FIRST 4 BYTES OF SYNTH DATA (ALWAYS COMMON)	
		BCF	PORTE,RFLE	;SYNTH LATCH ENABLE LOW TO START
		BCF	PORTE,RFLE	
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
SYNTHLOP	MOVLW	HIGH SYNTHEN	;LOAD UPPER BYTE OF SYNTH DATA TABLE
		MOVWF	MEMPOINT	;LOAD MEMORY PAGE POINTER
		MOVFW	SYNTHP
		CALL	READPROG	;W CONTAINS LOWER MEMORY READ ADDRESS ON CALL AND DATA CONTENTS ON RETURN
		CALL	SYNTHSEND	;SEND DATA TO SYNTH
		INCF	SYNTHP,F	;GOTO NEXT EEPROM LOCATION
		DECF	R0,F
		BTFSS	STATUS,Z
		GOTO	SYNTHLOP
		BSF	PORTE,RFLE	;LATCH DATA INTO CHIP
		BSF	PORTE,RFLE
		RETURN
;
SYNTHFQ		MOVLW	004H		;LOAD EACH SYTHESIZER REGISTER IN TURN WITH 4 BYTES
		MOVWF	R0		;LOAD COUNTER WITH FIRST 4 BYTES OF SYNTH DATA (ALWAYS COMMON)	
		BCF	PORTE,RFLE	;SYNTH LATCH ENABLE LOW TO START
		BCF	PORTE,RFLE	
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
		BCF	PORTC,RFDATA	;SYNTH DATA LOW
SYNTHLQ		MOVFW	SYNTHP
		CALL	READEE		;W CONTAINS LOWER MEMORY READ ADDRESS ON CALL AND DATA CONTENTS ON RETURN
		CALL	SYNTHSEND	;SEND DATA TO SYNTH
		INCF	SYNTHP,F	;GOTO NEXT EEPROM LOCATION
		DECF	R0,F
		BTFSS	STATUS,Z
		GOTO	SYNTHLQ
		BSF	PORTE,RFLE	;LATCH DATA INTO CHIP
		BSF	PORTE,RFLE
		RETURN
;
SYNTHSEND	MOVWF	R2		;SAVE DATA
		MOVLW	08H		;8 DATA BITS TO SEND
		MOVWF	R1
SYNSELOP	BTFSS	R2,7
		GOTO	SYNDATL
		BSF	PORTC,RFDATA	;SET UP DATA LINE
		BSF	PORTC,RFDATA	;SET UP DATA LINE
		GOTO	SYNDATSE
SYNDATL		BCF	PORTC,RFDATA
		BCF	PORTC,RFDATA
SYNDATSE	NOP
		BSF	PORTC,RFCLK
		BSF	PORTC,RFCLK	;SYNTH CLOCK HIGH
		NOP
		BCF	PORTC,RFCLK	;TOGGLE CLOCK
		BCF	PORTC,RFCLK	;SYNTH CLOCK LOW
		BCF	STATUS,C
		RLF	R2,F		;POINT TO NEXT BIT
		DECF	R1,F
		BTFSS	STATUS,Z
		GOTO	SYNSELOP
		RETURN
;
;************************* DAC SPI WRITE ROUTINE ******************************
;
;WRITE SPI DATA TO DAC TO TUNE REF OSC , 24 BITS ARE REQUIRED
;
SPIWR		BCF	PORTC,RFCLK	;SPI CLOCK LOW
		BCF	PORTC,RFCLK	;SPI CLOCK LOW
		BCF	PORTC,RFDATA	;SPI DATA LOW
		BCF	PORTC,RFDATA	;SPI DATA LOW
		BCF	PORTE,DACSTB	;LATCH ENABLE LOW TO START	
		BCF	PORTE,DACSTB
;
		MOVFW	RTUNEH		;GET REF TUNE DATA HIGH BITS
		MOVWF	SPIDH
		MOVFW	RTUNEL		;GET REF TUNE DATA LOW BITS
		MOVWF	SPIDM
		CLRF	SPIDL		;SET UP POWER CONTROL OF DAC AND DONT CARE BITS BITS
;
		BCF	STATUS,C	;CLEAR CARRY BEFORE SHIFTS, LSB DAC POWER CONTROL
		RRF	SPIDH,F
		RRF	SPIDM,F
		RRF	SPIDL,F		
		BCF	STATUS,C	;MSB DAC POWER CONTROL
		RRF	SPIDH,F
		RRF	SPIDM,F
		RRF	SPIDL,F		;GET BITS INTO CORRECT PLACES
;
		MOVFW	SPIDH		;GET FIRST BYTE DATA
		CALL	SPISEND		;SEND DATA TO SPI
		MOVFW	SPIDM		;GET SECOND BYTE DATA
		CALL	SPISEND		;SEND DATA TO SPI
		MOVFW	SPIDL		;GET THIRD BYTE DATA
		CALL	SPISEND		;SEND DATA TO SPI
;
		BSF	PORTE,DACSTB	;LATCH DATA INTO CHIP
		BSF	PORTE,DACSTB	;LATCH DATA INTO CHIP
		RETURN
;
SPISEND		MOVWF	R2		;SAVE DATA
		MOVLW	08H		;8 DATA BITS TO SEND
		MOVWF	R1
SPISELOP	BTFSS	R2,7
		GOTO	SPIDATL
		BSF	PORTC,RFDATA	;HIGH DATA LINE
		BSF	PORTC,RFDATA	
		GOTO	SPIDATSE
SPIDATL		BCF	PORTC,RFDATA	;LOW DATA LINE
		BCF	PORTC,RFDATA
SPIDATSE	NOP
		BSF	PORTC,RFCLK
		BSF	PORTC,RFCLK	;SPI CLOCK HIGH
		NOP
		NOP
		BCF	PORTC,RFCLK	;TOGGLE CLOCK
		BCF	PORTC,RFCLK	;SPI CLOCK LOW
		BCF	STATUS,C
		RLF	R2,F		;POINT TO NEXT BIT
		DECF	R1,F
		BTFSS	STATUS,Z
		GOTO	SPISELOP
		RETURN
;
;PLL ERROR LOOP ROUTINE
;
PLLERR		CALL	SYNTHOFF	;PUT SYNTH OFF
		CALL	LEDRED
		CALL	LBEEP
;
		CALL	LEDOFF
;
		CALL	GETREF		;KEEP VOLTAGES UPDATED IF IN PLL ERROR
		CALL	GETVCO
		CALL	GETVPWR		;GET RF CHIP RF POWER VOLTAGE
		CALL	GETVTEMP	;GET RF CHIP TEMPERATURE VOLTAGE
;
		BTFSC	PORTC,7		;CHECK IF RS232 IS CONNECTED
		CALL	PRINTSTAT	;YES SO PRINT STATUS
;		
		CALL	SYNTHINIT	;RE-INITIALIZE SYNTH
		CALL	LBEEP
		CALL	LEDGRN		;SHOW GREEN TO INDICATE FAULT MAYBE CLEARED
;
		CLRF	GFLAG		;CLEAR FLAG TO CAUSE RESTART OF STATE MACHINE
;
		RETURN
;
;************************* ADC CONVERTOR ROUTINES *****************************
;
;** GET DC INPUT
;
GETDC		BCF	GFLAG,LOWDC	;CLEAR LOW DC FLAG
		MOVLW	B'10000101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN0 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	084H		;RIGHT JUSTIFIED , 3 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
DCIL		BTFSC	ADCON0,2
		GOTO	DCIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	DCINHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	DCINLV		;PUT LOW RESULT IN REGISTER
;		
		MOVFW	DCINHV		;LOOK AT HIGH RESULT ONLY
		BTFSS	STATUS,Z
		RETURN			;COMPARE TO THRESHOLD
		CALL	LEDRED
		CALL	LBEEP		;ALARM IF TOO LOW
		BSF	GFLAG,LOWDC	;SET FLAG BIT TO SHOW LOW DC
		RETURN
;
;** GET VCO ERROR VOLTAGE
;
GETVCO		MOVLW	B'10011101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN3 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	082H		;RIGHT JUSTIFIED , 5 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
VCOIL		BTFSC	ADCON0,2
		GOTO	VCOIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	VCOHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	VCOLV		;PUT LOW RESULT IN REGISTER
		RETURN
;
;** GET 10MHz REFERANCE TUNE VOLTAGE
;
GETREF		MOVLW	B'10001101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN1 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	082H		;RIGHT JUSTIFIED , 5 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
REFIL		BTFSC	ADCON0,2
		GOTO	REFIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	REFHV		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	REFLV		;PUT LOW RESULT IN REGISTER
		RETURN
;
;** GET RF CHIP TEMPERATURE VOLTAGE
;
GETVTEMP	MOVLW	B'10100101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN4 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	082H		;RIGHT JUSTIFIED , 5 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
VTEMPIL		BTFSC	ADCON0,2
		GOTO	VTEMPIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	VTEMPH		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	VTEMPL		;PUT LOW RESULT IN REGISTER
		RETURN
;
;** GET TX POWER VOLTAGE
;
GETVPWR		MOVLW	B'10010101'	;SET UP A/D INPUT HERE
		BANKSEL	0
		MOVWF	ADCON0		;OSC/32 , AN2 SELECTED
;
		BSF	STATUS,RP0	;BANK 1
		MOVLW	082H		;RIGHT JUSTIFIED , 5 ANALOGUE IN , REF VDD & VSS
		MOVWF	ADCON1
		BCF	STATUS,RP0	;BANK 0
;
		CALL	ADCWAIT		;WAIT ROUTINE FOR ADC INPUT SETTLE
		BSF	ADCON0,2	;START CONVERSION
;
VPWRIL		BTFSC	ADCON0,2
		GOTO	VPWRIL		;LOOP TILL CONVERSION DONE
		MOVFW	ADRESH
		MOVWF	VPWRH		;PUT HIGH RESULT IN REGISTER
		BSF	STATUS,RP0	;BANK1
		MOVFW	ADRESL
		BCF	STATUS,RP0	;BANK0
		MOVWF	VPWRL		;PUT LOW RESULT IN REGISTER
		RETURN
;
;
;
;******************************************************************************
;
;*************************** DICIPLING ROUTINES *******************************
;
;******************************************************************************
;
;	TIMER 1 SET UP FOR 1PPS CAPTURE WITH INTERRUPTS
;
TSETUP1		MOVLW	B'00000001'	;SET UP TIMER 1, NO PRE SCALE, Fosc/4, ENABLE TIMER 1
		BANKSEL	T1CON
		MOVWF	T1CON
;
		BANKSEL	CCP1CON
		MOVLW	B'00000100'	;SET UP CAPTURE COMPARE 1 INPUT, FALLING EDGE, SOURCE TIMER 1
		MOVWF	CCP1CON				
		BANKSEL	0
		RETURN
;
;	TIMER 1 SET UP FOR 10MHz EXT CLOCK AND OVERFLOW INTERRUPT
;
TSETUP10	MOVLW	B'00000111'	;SET UP TIMER 1, NO PRE SCALE, EXT CLOCK, ENABLE TIMER 1
		BANKSEL	T1CON
		MOVWF	T1CON
		BANKSEL	0
		RETURN
;
;
;******************************************************************************
;
;************************* INTERRUPRT SERVICE ROUTINE *************************
;
;******************************************************************************
;
INTSERV		CLRF	INTCON		;STOP INTERRUPTS AND SAVE CONTEXT
		MOVWF	W_TEMP 		;Copy W to TEMP register
		SWAPF	STATUS,W 	;Swap status to be saved into W
		CLRF	STATUS 		;bank 0, regardless of current bank, Clears IRP,RP1,RP0
		MOVWF	STATUS_TEMP 	;Save status to bank zero STATUS_TEMP register
		MOVF	PCLATH,W 	;Only required if using pages 1, 2 and/or 3
		MOVWF	PCLATH_TEMP 	;Save PCLATH into W
		CLRF 	PCLATH 		;Page zero, regardless of current page
;
		BSF	DISREG,INTHH	;SET INTERRUPT FLAG
		BTFSC	DISREG,EXT10	;CHECK IF 1PPS OR 10MHZ FOR DICIPLINING
		GOTO	INT10M
;
;** 1 PPS DICIPLINING ROUTINES
;
		BANKSEL	CCPR1L		;READ CAPTURE RESULT
		MOVFW	CCPR1L
		BANKSEL	0
		ANDLW	B'00011111'	;MASK OFF UNSUITABLE BITS
		MOVWF	RERROR		;SAVE CURRENT ERROR VALUE
;
		BSF	PORTD,OL1	;PUT ON 1 PPS DICIPLINING LED
		BSF	PORTD,OL1
;
		CLRF	LOOPC		;CLEAR LOOP COUNTER TO RESET TIMING ON GPS PULSE
;
;CHECK IF LOW DC INPUT VOLTS HERE, ABBORT IF VOLTS LOW OR FALLING
;
		MOVF	DCINHV,F
		BTFSC	STATUS,Z	;IF VOLTS LOW THEN ABBORT	
		GOTO	INTDUN
;
		MOVFW	LASTRERROR	;CHECK IF LAST RESULT WAS 0
		BTFSC	STATUS,Z	;AVOID POSIBLE ROLL UNDER ERROR
		GOTO	ROLZERO	
		SUBLW	01FH		;CHECK IF LAST RESULT WAS 01FH
		BTFSC	STATUS,Z	;AVOID POSSIBLE ROLL OVER ERROR
		GOTO	ROLMAX
;
		MOVFW	LASTRERROR
		SUBWF	RERROR,W	;COMPARE RESULTS
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR
		BTFSS	STATUS,C	;CHECK IF POSITIVE OR NEGATIVE ERROR
		GOTO	ERRORUP
		GOTO	ERRORDN
;
ROLZERO		MOVFW	LASTRERROR	;LAST ERROR WAS ZERO
		SUBWF	RERROR,W	;COMPARE
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR	
		BTFSS	STATUS,C	;CHECK IF UP OR DOWN REQUIRED	
		GOTO	ERRORDN
		GOTO	ERRORUP
;
ROLMAX		MOVFW	LASTRERROR	;LAST ERROR WAS MAXED (01FH)
		SUBWF	RERROR,W
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR
		BTFSS	STATUS,C	;CHECK IF UP OR DOWN REQUIRED	
		GOTO	ERRORUP
;
ERRORDN		BSF	DISREG,ERRCOR	;SHOW A CORRECTION IS REQUIRED
		BCF	DISREG,ERRCORD	;SHOW NEGATIVE CORRECTION SO DECREASE TUNE REGISTERS
;
		BTFSS	DISREG,LERRCORD	;CHECK WHAT DIRECTION WAS LAST
		GOTO	TCORRSD			
TCORRDD		BCF	STATUS,C	;DIVIDE CORRECTION AMOUNT  /2
		RRF	TCORR,F
		MOVF	TCORR,F
		BTFSC	STATUS,Z	;DON'T ALLOW TO GO TO ZERO	
		INCF	TCORR,F
		GOTO	DOERRORUD	
;
TCORRSD		BSF	STATUS,C	;MULTIPLY CORRECTION AMOUNT BY 2
		RLF	TCORR,F
;
DOERRORUD	MOVFW	TCORR		;SUBTRACT CORRECTION AMOUNT
		SUBWF	RTUNEL,F	;DECREASE TUNE LOW REGISTER 
		BTFSS	STATUS,C	;CHECK IF CARRY FROM SUBTRACTION
		DECF	RTUNEH,F	;DEC HIGH REG IF ROLL	
		CLRF	NERCOUNT
		BCF	DISREG,LERRCORD	;SHOW NEGATIVE CORRECTION WAS LAST
;
		GOTO	ENDERROR
;
ERRORUP		BSF	DISREG,ERRCOR	;SHOW A CORRECTION IS REQUIRED
		BSF	DISREG,ERRCORD	;SHOW POSITIVE CORRECTION SO INCREASE TUNE REGISTERS
;
		BTFSC	DISREG,LERRCORD	;CHECK WHAT DIRECTION WAS LAST
		GOTO	TCORRS			
TCORRD		BCF	STATUS,C	;DIVIDE CORRECTION AMOUNT  /2
		RRF	TCORR,F
		MOVF	TCORR,F
		BTFSC	STATUS,Z	;DON'T ALLOW TO GO TO ZERO	
		INCF	TCORR,F
		GOTO	DOERRORU	
;
TCORRS		BSF	STATUS,C	;MULTIPLY CORRECTION AMOUNT BY 2
		RLF	TCORR,F
;
DOERRORU	MOVFW	TCORR		;ADD CORRECTION AMOUNT
		ADDWF	RTUNEL,F	;INCREASE TUNE LOW REGISTER 
		BTFSC	STATUS,C	;CHECK IF CARRY FROM ADITTION
		INCF	RTUNEH,F	;INC HIGH REG IF ROLL	
		CLRF	NERCOUNT
		BSF	DISREG,LERRCORD	;SHOW POSITIVE CORRECTION WAS LAST

;
ENDERROR	MOVLW	CORTHRESH	
		SUBWF	NERCOUNT,W	;CHECK IF NERCOUNT ABOVE CORECTION THRESHOLD
		BTFSS	STATUS,C
		GOTO	ENDERBT		;IF BELOW THRESHOLD THEN KEEP GOING	
		MOVLW	001H
		MOVWF	TCORR		;SET TCORR TO 1 IF ABOVE THRESHOLD
;
ENDERBT		INCF	NERCOUNT,F	;INCREMENT NO ERROR COUNT 
		BTFSC	STATUS,Z	;CHECK IF ROLL OVER TO ZERO
		DECF	NERCOUNT,F	;DON'T ALLOW ROLL OVER OF NO ERROR COUNTER
;
		MOVFW	RERROR
		MOVWF	LASTRERROR	;UPDATE LAST ERROR VALUE
;
		BSF	DISREG,GDIS	;SHOW GPS DISCIPLINING IS VALID	
;
INTDUN		NOP
		BANKSEL	PIR1		;CLEAR CCP1 INTERRUPT FLAG AND ENABLE INTERRUPTS
		BCF	PIR1,CCP1IF
		BANKSEL	PIE1
		BSF	PIE1,CCP1IE	;ENABLE CCP1 INT
		BANKSEL	0
		BSF	INTCON,PEIE	;ENABLE PERIPHERAL INTERRUPTS
		GOTO	INTRET
;		
;** EXTERNAL 10 MHz DICIPLINING ROUTINES 
;
INT10M		MOVFW	TMR2
		MOVWF	RERROR		;STORE TIMER2 ERROR VALUE
		CLRF	TMR2		;CLEAR TIMER 2 EACH TIME
		BCF	PORTD,OL1
		BTFSS	LOOPC,6		;FLASH OL1 
		BSF	PORTD,OL1
;
;CHECK IF LOW DC INPUT VOLTS HERE, ABBORT IF VOLTS LOW OR FALLING
;
		MOVF	DCINHV,F
		BTFSC	STATUS,Z	;IF VOLTS LOW THEN ABBORT	
		GOTO	INT10DUN
;		
		MOVFW	TMR1L		;GET ERROR VALUE FROM TIMER 1
		ANDLW	B'00000011'	;MASK OFF UNSUITABLE BITS
		MOVWF	RERROR		;STORE ERROR
;		
		MOVF	LASTRERROR,F	;CHECK IF LAST RESULT WAS 000H
		BTFSC	STATUS,Z	;AVOID POSIBLE ROLL UNDER ERROR
		GOTO	ROLZERO10	
		MOVFW	LASTRERROR
		SUBLW	03H		;CHECK IF LAST RESULT WAS 003H
		BTFSC	STATUS,Z	;AVOID POSSIBLE ROLL OVER ERROR
		GOTO	ROLMAX10
;
		MOVFW	LASTRERROR
		SUBWF	RERROR,W	;COMPARE RESULTS
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR10
		BTFSS	STATUS,C	;CHECK IF POSITIVE OR NEGATIVE ERROR
		GOTO	ERRORUP10
		GOTO	ERRORDN10
;
ROLZERO10	MOVFW	LASTRERROR	;LAST ERROR WAS ZERO
		SUBWF	RERROR,W	;COMPARE
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR10	
		MOVFW	RERROR
		SUBLW	003H
		BTFSS	STATUS,Z	;CHECK IF 003H
		GOTO	ERRORDN10	;CHECK IF UP OR DOWN REQUIRED
		GOTO	ERRORUP10	
;
ROLMAX10	MOVFW	LASTRERROR	;LAST ERROR WAS MAXED (003H)
		SUBWF	RERROR,W
		BTFSC	STATUS,Z	;CHECK IF NO CHANGE
		GOTO	ENDERROR10
		MOVF	RERROR,F
		BTFSC	STATUS,Z	;CHECK IF 0, ROLL HAS OCCURRED	
		GOTO	ERRORDN10
;
ERRORUP10	BSF	DISREG,ERRCOR	;SHOW A CORRECTION IS REQUIRED
		BCF	DISREG,ERRCORD	;SHOW NEGATIVE CORRECTION SO DECREASE TUNE REGISTERS
;
		BTFSS	DISREG,LERRCORD	;CHECK WHAT DIRECTION WAS LAST
		GOTO	TCORRSD10			
TCORRDD10	BCF	STATUS,C	;DIVIDE CORRECTION AMOUNT  /2
		RRF	TCORR,F
		MOVF	TCORR,F
		BTFSC	STATUS,Z	;DON'T ALLOW TO GO TO ZERO	
		INCF	TCORR,F
		GOTO	DOERRORUD10	
;
TCORRSD10	BSF	STATUS,C	;MULTIPLY CORRECTION AMOUNT BY 2
		RLF	TCORR,F
;
DOERRORUD10	MOVFW	TCORR		;SUBTRACT CORRECTION AMOUNT
		SUBWF	RTUNEL,F	;DECREASE TUNE LOW REGISTER 
		BTFSS	STATUS,C	;CHECK IF CARRY FROM SUBTRACTION
		DECF	RTUNEH,F	;DEC HIGH REG IF ROLL	
		CLRF	NERCOUNT
		BCF	DISREG,LERRCORD	;SHOW NEGATIVE CORRECTION WAS LAST
		GOTO	ENDERROR10
;
ERRORDN10	BSF	DISREG,ERRCOR	;SHOW A CORRECTION IS REQUIRED
		BCF	DISREG,ERRCORD	;SHOW NEGATIVE CORRECTION SO DECREASE TUNE VALUE
;
		BTFSC	DISREG,LERRCORD	;CHECK WHAT DIRECTION WAS LAST
		GOTO	TCORRS10			
TCORRD10	BCF	STATUS,C	;DIVIDE CORRECTION AMOUNT  /2
		RRF	TCORR,F
		MOVF	TCORR,F
		BTFSC	STATUS,Z	;DON'T ALLOW TO GO TO ZERO	
		INCF	TCORR,F
		GOTO	DOERRORU10	
;
TCORRS10	BSF	STATUS,C	;MULTIPLY CORRECTION AMOUNT BY 2
		RLF	TCORR,F
;
DOERRORU10	MOVFW	TCORR		;ADD CORRECTION AMOUNT
		ADDWF	RTUNEL,F	;INCREASE TUNE LOW REGISTER 
		BTFSC	STATUS,C	;CHECK IF CARRY FROM ADITTION
		INCF	RTUNEH,F	;INC HIGH REG IF ROLL	
		CLRF	NERCOUNT
		BSF	DISREG,LERRCORD	;SHOW POSITIVE CORRECTION WAS LAST
;
ENDERROR10	MOVFW	LOOPC
		BTFSS	STATUS,Z	;ONLY ALLOW CHANGE OF ERROR COUNT WHEN LOOPC = 0
		GOTO	M10LERR	
;
		MOVLW	CORTHRESH10	
		SUBWF	NERCOUNT,W	;CHECK IF NERCOUNT ABOVE CORECTION THRESHOLD
		BTFSS	STATUS,C
		GOTO	ENDERBT10	;IF BELOW THRESHOLD THEN KEEP GOING	
		MOVLW	001H
		MOVWF	TCORR		;SET TCORR TO 1 IF ABOVE THRESHOLD
;
ENDERBT10	INCF	NERCOUNT,F	;INCREMENT NO ERROR COUNT 
		BTFSC	STATUS,Z	;CHECK IF ROLL OVER TO ZERO
		DECF	NERCOUNT,F	;DON'T ALLOW ROLL OVER OF NO ERROR COUNTER
;
M10LERR		MOVFW	RERROR
		MOVWF	LASTRERROR	;UPDATE LAST ERROR VALUE
;
		BSF	DISREG,M10DIS	;SHOW 10MHz DICIPLINING ACTIVE
;
INT10DUN	NOP
		BANKSEL	PIR1		;SET UP TIMER 1 OVERFLOW INTERRUPTS
		BCF	PIR1,TMR1IF	;RESET INT FLAG				
		BANKSEL	PIE1
		BSF	PIE1,TMR1IE	;ENABLE TIMER1 INT
		BANKSEL	0
		BSF	INTCON,PEIE	;ENABLE PERIPHERAL INTERRUPTS
;
INTRET		MOVF	PCLATH_TEMP,W 	;Restore PCLATH
		MOVWF	PCLATH 		;Move W into PCLATH
		SWAPF	STATUS_TEMP,W 	;Swap STATUS_TEMP register into W
		MOVWF	STATUS 		;Move W into STATUS register
		SWAPF	W_TEMP,F 	;Swap W_TEMP
		SWAPF	W_TEMP,W 	;Swap W_TEMP into W
;
		RETFIE			;RETURN FROM INTERRUPT , ALSO ENABLES GIE
;
;
;******************************************************************************
;**************************** GENERAL SUBROUTINES *****************************
;******************************************************************************
;
;
;******************************************************************************
;
;RS232 DATA COMMS ROUTINES
;
;******************************************************************************
;
CHKCOMMS	NOP			;CHECK FOR RX RS232 COMMS
		BANKSEL	0			
		BTFSC	RCSTA,1		;CHECK FOR SERIAL ERRORS
		CALL	CLRCOMME
		BTFSC	RCSTA,2
		CALL	CLRCOMME
;
		BTFSS	PIR1,RCIF	;CHECK IF CHARACTER RECEIVED
		RETURN			;NO DATA SO RETURN
;
NEWCOMM		MOVLW	HIGH COMPROMPT	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW COMPROMPT	;PRINT COMMAND PROMPT
		CALL	PRMEM
		MOVLW	COMMSBUFF0
		MOVWF	COMPOINT	;SET UP COMMS BUFFER POINTER START
;
COMMSRX		MOVLW	080H		;CHARACTER RECEIVED
		MOVWF	SERTOC		;LOAD TIME OUT COUNTER
;
		BCF	PIR1,RCIF	;CLEAR RECEIVED FLAG
		MOVFW	COMPOINT
		MOVWF	FSR
		MOVFW	RCREG		;READ RS232 RX DATA
		MOVWF	INDF		;USE POINTER TO WRITE TO BUFFER		
		INCF	COMPOINT,F	;GOTO NEXT LOCATION
		SUBLW	00DH		;CHECK IF "CR" RECEIVED
		BTFSC	STATUS,Z
		GOTO	SERPROC		;PROCESS COMMAND
;
		MOVFW	INDF
		SUBLW	01BH		;CHECK IF ESC
		BTFSC	STATUS,Z
		RETURN			;ABBORT COMMAND IF ESC
;
		MOVFW	INDF		;READ DATA FROM BUFFER
		CALL	TXCOMS		;ECHO CHARACTER
;
		MOVFW	COMPOINT
		SUBLW	COMMSBUFFE+1	;CHECK IF AT END OF BUFFER		
		BTFSC	STATUS,Z
		GOTO	SERPROC		;IF AT END THEN AUTOMATICALLY PROCESS
;
COMWAITH	CALL	WAIT		;LOOP TILL COMMAND COMPLETED OR TIME OUT
		DECF	SERTOC,F	;DECREMENT COMAND TIME OUT COUNTER
		BTFSC	STATUS,Z
		GOTO	SERERR	
		BTFSS	PIR1,RCIF	;CHECK IF DATA RECEIVED	
		GOTO	COMWAITH	;LOOP TILL DATA RECEIVED OR TIME OUT		
		GOTO	COMMSRX
;
SERERR		MOVLW	HIGH COMERROR	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW COMERROR	;PRINT ERROR
		CALL	PRMEM
		MOVLW	HIGH NOERROR	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW NOERROR	;PRINT SPACES
		CALL	PRMEM
		CALL	WAITONE
		CALL	WAITONE
		RETURN
;
CLRCOMME	MOVFW	RCREG
		BCF	RCSTA,CREN	;CLEAR RXCOMS ERRORS
		BSF	RCSTA,CREN
		MOVFW	RCREG		;READ BUFFER TO CLEAR DATA
		RETURN
;
;SERIAL COMMAND TRAPPING
;
SERPROC		MOVLW	COMMSBUFF0	;PROCESS INCOMING SERIAL DATA 
		MOVWF	FSR		;INDIRECT POINTER LOAD
		MOVFW	INDF		;USE POINTER TO READ COMMAND BUFFER		
		MOVWF	R0		;TEMP STORE
		BCF	R0,5		;FORCE UPPER CASE ONLY
;
		MOVFW	R0
		SUBLW	"T"		;TRAP FOR "T" TUNE	
		BTFSC	STATUS,Z
		GOTO	COMTUN		;COMMAND IS TUNE
;
		MOVFW	R0
		SUBLW	"B"		;TRAP FOR "B" BEACON
		BTFSC	STATUS,Z
		GOTO	COMMOR		;COMMAND IS BEACON
;
		MOVFW	R0
		SUBLW	"E"		;TRAP FOR "E" EEPROM CHANNEL USER PROGRAM
		BTFSC	STATUS,Z
		GOTO	COMEUP		;COMMAND IS EEPROM USER PROG
;
		MOVFW	R0
		SUBLW	"C"		;TRAP FOR "C" MORSE BEACON CARRIER TIME
		BTFSC	STATUS,Z
		GOTO	COMMBC		;COMMAND IS BEACON CARRIER TIME
;
		MOVFW	R0
		SUBLW	"D"		;TRAP FOR "D" DEFAULT EEPROM CHANNEL TABLE
		BTFSC	STATUS,Z
		GOTO	COMDEF		;COMMAND IS DEFAULT EEOROM CHANNEL TABLE
;
;
;OTHER RS232 COMMANDS GO HERE
;
		GOTO	SERERR		;UNKNOWN COMMAND SO ABBORT WITH ERROR
;
;
;
;SERIAL COMMAND PROCESSING
;
COMTUN		INCF	FSR,F		;POINT TO NEXT LOCATION
		MOVFW	INDF		;GET FIRST BYTE
		MOVWF	R1		;STORE FOR CONVERSION	
		INCF	FSR,F
		MOVFW	INDF		;GET SECOND BYTE
		MOVWF	R0
		CALL	ASCII2HEX	;CONVERT TO HEX
		MOVWF	R0		;TEMP STORE
		MOVLW	LOW ERTUNEH
		MOVWF	EEPOINT
		MOVFW	R0		;GET DATA
		CALL	EEWRITE		;WRITE TO EEPROM
;
		INCF	FSR,F		;POINT TO NEXT LOCATION
		MOVFW	INDF		;GET FIRST BYTE
		MOVWF	R1		;STORE FOR CONVERSION	
		INCF	FSR,F
		MOVFW	INDF		;GET SECOND BYTE
		MOVWF	R0
		CALL	ASCII2HEX	;CONVERT TO HEX
		MOVWF	R0		;TEMP STORE
		MOVLW	LOW ERTUNEL
		MOVWF	EEPOINT
		MOVFW	R0		;GET DATA
		CALL	EEWRITE
		GOTO	COMMEND		;END COMMAND	
;
COMMOR		MOVLW	LOW IDENTMORSE
		MOVWF	EEPOINT		;LOAD EEPROM POINTER TO START OF MORSE CALLSIGN
		INCF	FSR,F		;POINT TO START OF NEW USER INPUT DATA
		MOVLW	D'24'		;SET MAXIMUM CALLSIGN LENGTH (24D)
		MOVWF	R0		;MAX LOOP COUNTER
WRMORLOP	MOVFW	INDF		;GET DATA FROM BUFFER		
		MOVWF	R1		;TEMP STORE
		SUBLW	00DH	
		BTFSC	STATUS,Z
		CLRF	R1		;SET DATA TO OOOH IF ASCII WAS OODH (CR)
		MOVFW	R1		;GET DATA
		CALL	EEWRITE
		INCF	EEPOINT,F	;POINT TO NEXT EEPROM LOCATION
		INCF	FSR,F		;POINT TO NEXT BUFFER LOCATION
		DECF	R0,F
		BTFSS	STATUS,Z
		GOTO	WRMORLOP	;CONTINUE LOOP
		CLRW
		CALL	EEWRITE		;ENSURE LAST BYTE IS 000H
		GOTO	COMMEND		;END COMMAND
;
COMEUP		INCF	FSR,F		;POINT TO START OF NEW USER INPUT DATA
		MOVLW	D'12'		;SET MAXIMUM OUTPUT DATA LENGTH (6 X 2 BUFFER BYTES = 12D)
		MOVWF	R2		;MAX LOOP COUNTER
;		
		MOVFW	INDF		;GET FIRST BYTE OF CHANNEL NUMBER
		MOVWF	R1		;TEMP STORE OF EACH MSB
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS OODH (CR)
		INCF	FSR,F
		MOVFW	INDF		;GET DATA FROM BUFFER		
		MOVWF	R0		;TEMP STORE OF EACH LSB
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND
		CALL	ASCII2HEX	;CONVERT 2 BYTE ASCII R1&R0 INTO 1 BYTE HEX
		MOVWF	EEPOINT		;TEMP STORE IN EEPROM POINTER
		MOVWF	R0		;SECOND TEMP STORE
;
		SUBLW	00FH		;CHECK THAT USER INPUT CHANNEL IS 00FH OR LESS
		BTFSS	STATUS,C
		GOTO	SERERR		;SHOW ERROR IF CHANNEL WRONG
;
		BCF	STATUS,C
		RLF	EEPOINT,F
		BCF	STATUS,C	;MULT X 5 (4+1)	
		RLF	EEPOINT,F
		MOVFW	R0		;MULTIPLY EEPOINT X 5 TO POINT TO CORRECT EEPROM LOCATION
		ADDWF	EEPOINT,F	;EEPOINT NOW CONTAINS CORRECT START OF CHANNEL NUMBER
		INCF	FSR,F		;POINT TO FIRST INPUT DATA LOCATION
;
EUPLOP		MOVFW	INDF		;GET DATA FROM BUFFER		
		MOVWF	R1		;TEMP STORE OF EACH MSB
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS OODH (CR)
		INCF	FSR,F
		MOVFW	INDF		;GET DATA FROM BUFFER		
		MOVWF	R0		;TEMP STORE OF EACH LSB
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS OODH (CR)
		CALL	ASCII2HEX	;CONVERT 2 BYTE ASCII R1&R0 INTO 1 BYTE HEX	
		CALL	EEWRITE
		INCF	EEPOINT,F	;POINT TO NEXT EEPROM LOCATION
		INCF	FSR,F		;POINT TO NEXT BUFFER LOCATION
		DECF	R2,F		;CHECK IF LOOP LENGTH EXCEEDED
		BTFSS	STATUS,Z
		GOTO	EUPLOP		;CONTINUE LOOP
;
		GOTO	COMMEND		;DONE
;
COMMBC		INCF	FSR,F		;POINT TO START OF USER INPUT NEW DATA
		MOVFW	INDF		;GET MSB DATA FROM BUFFER		
		MOVWF	R1		;TEMP STORE
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS OODH (CR)
		INCF	FSR,F
		MOVFW	INDF
		MOVWF	R0
		SUBLW	00DH	
		BTFSC	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS OODH (CR)
		MOVLW	LOW ECARDEL
		MOVWF	EEPOINT		;LOAD EEPROM POINTER TO BEACON CARRIER DELAY
		CALL	ASCII2HEX	;CONVERT USER INPUT R1&R0 VALUES TO HEX BYTE IN W
		CALL	EEWRITE		;WRITE NEW DATA TO EEPROM
		GOTO	COMMEND
;
COMDEF		INCF	FSR,F		;POINT TO START OF INPUT DATA, DEFAULT EEPROM VALUES TO HARD CODED DEFAULTS 
		MOVFW	INDF		;GET MSB DATA FROM BUFFER		
		MOVWF	R1		;TEMP STORE
		SUBLW	"C"	
		BTFSS	STATUS,Z
		GOTO	SERERR		;ABBORT WITH ERROR IF ASCII WAS NOT ASCII "C"
;
		INCF	FSR,F		;POINT TO NEXT INPUT NEW DATA
		MOVFW	INDF		;GET MSB DATA FROM BUFFER		
		MOVWF	R1		;TEMP STORE
		SUBLW	00DH		;CHECK IF NEXT CHARACTER IS ASCII "C"	
		BTFSS	STATUS,Z
		GOTO	COMMEND		;ABBORT IF ASCII WAS NOT 00DH CR
;
		MOVLW	LOW FREQ0	;WRITE HARD CODED DEFAULTS TO EEPROM
		MOVWF	EEPOINT		;LOAD EEPROM POINTER TO START CHANNEL DATA
		MOVLW	D'96'		;SET MAXIMUM OUTPUT DATA LENGTH (16 CHANNELS X 6 BYTES = 96D)
		MOVWF	R2		;MAX LOOP COUNTER
		MOVLW	HIGH DEFFDATA0 	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD PROGRAM MEMORY POINTER
		MOVLW	LOW DEFFDATA0
		MOVWF	R0		;USE R0 FOR MEMORY POINTER
;		
CDEFLOP		MOVFW	R0		;R0 CONTAINS READ ADDRESS
		CALL	READPROG	;READ 1 BYTE FROM PROGRAM MEMORY, DATA IN W
		CALL	EEWRITE
		INCF	EEPOINT,F
		INCF	R0,F
		DECF	R2,F
		BTFSS	STATUS,Z	;CHECK IF ALL DONE
		GOTO	CDEFLOP		;LOOP TILL DONE					
;
		GOTO	COMMEND


;NEW COMMAND PROCESSING ROUTINES GO HERE
;
		NOP
;
;
;
COMMEND		MOVLW	HIGH COMOK	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW COMOK
		CALL	PRMEM
;
ENDCOMMS	CLRF	INTCON		;STOP INTERRUPTS BEFORE RE-BOOT
		CALL	WAITONE
		CALL	WAITONE
		GOTO	0000H		;RE-BOOT TO READ ALL NEW EEPROM DATA
;
;PRINT STATUS
;
PRINTSTAT	BTFSC	PORTC,RFMUX	;CHECK IF PLL LOCKED		
		GOTO	STATNORM
		MOVLW	HIGH PLLERRT	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW PLLERRT	;PLL ERROR STRING FROM PROGRAM MEMORY
		CALL	PRMEM			
;	
STATNORM	BTFSS	GFLAG,LOWDC	;CHECK IF DC IS LOW
		GOTO	PRINTR
		MOVLW	HIGH LOWDCERRT	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW LOWDCERRT	;LOW DC ERROR STRING FROM PROGRAM MEMORY
		CALL	PRMEM
;
PRINTR		MOVLW	HIGH NOERROR	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW NOERROR	;NO ERROR STRING FROM PROGRAM MEMORY
		CALL	PRMEM
		MOVLW	00DH
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
		MOVFW	RERROR
		CALL	PHEX		;SEND STATUS TO RS232
		MOVFW	RTUNEH		
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS		;BS TO GIVE 2 BYTE PACKED RESULT
		MOVFW	RTUNEL
		CALL	PHEX
		MOVFW	REFHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS		;BS TO GIVE 2 BYTE PACKED RESULT
		MOVFW	REFLV
		CALL	PHEX
		MOVFW	NERCOUNT
		CALL	PHEX
		MOVFW	VCOHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	VCOLV
		CALL	PHEX
		MOVFW	DCINHV
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	DCINLV
		CALL	PHEX
		MOVFW	VPWRH
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	VPWRL
		CALL	PHEX
		MOVFW	VTEMPH
		CALL	PHEX
		MOVLW	08H
		CALL	TXCOMS
		MOVFW	VTEMPL
		CALL	PHEX
		MOVLW	020H
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
;
		BTFSC	GFLAG,CURS	;FLASH CURSOR ROUTINE	
		GOTO	CURSOFF
CURSON		BSF	GFLAG,CURS
		MOVLW	03EH		;>
		CALL	TXCOMS
		MOVLW	05FH		;_
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS		;SPACE
		GOTO	CURSEND
;
CURSOFF		BCF	GFLAG,CURS
		MOVLW	020H
		CALL	TXCOMS
		MOVLW	020H
		CALL	TXCOMS
CURSEND		BTFSS	DISREG,GDIS	;CHECK IF GPS DICIPLINING IS ACTIVE
		GOTO	CHKC10M
		BCF	DISREG,GDIS	;RESET GPS DISCIPLINING FLAG		
		MOVLW	HIGH GPSSTRING	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW GPSSTRING	;SEND GPS STRING
		CALL	PRMEM
		RETURN
CHKC10M		BTFSS	DISREG,M10DIS	;CHECK IF 10 MHz DICIPLINING IS ACTIVE
		RETURN
		MOVLW	B'01000000'	;TOGGL BIT 6 (TTEN FLAG)
		XORWF	DISREG,F
		BTFSS	DISREG,TTEN
		RETURN
		BCF	DISREG,M10DIS	;RESET 10MHz DISCIPLINING FLAG		
		MOVLW	HIGH M10STRING	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW M10STRING	;SEND 10 MHz STRING
		CALL	PRMEM
		
		RETURN
;
PRBOOT		MOVLW	007H		;PRINT BOOT UP STRING , BELL
		CALL	TXCOMS
		MOVLW	00CH		;FORM FEED
		CALL	TXCOMS
		CALL	PRCRLF
		MOVLW	HIGH TXTBOOT	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW TXTBOOT	;BOOT STRING FROM PROGRAM MEMORY
		CALL	PRMEM			
		CALL	PRCRLF
		CALL	PRCRLF
		MOVLW	HIGH SERIAL	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW SERIAL	;LOAD SERIAL # ADDRESS FROM EEPROM	
		CALL	PRMEM
		CALL	PRCRLF
		CALL	PRCRLF
		MOVLW	HIGH CALLHEAD	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW CALLHEAD	;CALLSIGN HEADER
		CALL	PRMEM
;
		MOVLW	LOW IDENTMORSE	;GET MORSE CALLSIGN HEADER
		MOVWF	TEMP		;TEMP STORE
MCALLPR		MOVFW	TEMP
		CALL	READEE		;READ EEPROM DATA		
		BTFSC	STATUS,Z	;CHECK IF DATA IS 000H	
		GOTO	ENDMPR		;END OF MORSE STRING SO CONTINUE BOOT UP PRINTING
		CALL	TXCOMS		;PRINT MORSE DATA
		INCF	TEMP,F		;GOTO NEXT LOCATION
		GOTO	MCALLPR		;CONTINUE TILL DONE
;
ENDMPR		CALL	PRCRLF		;PRINT MORSE BEACON CARRIER DELAY HEADER AND VALUE
		CALL	PRCRLF
		MOVLW	HIGH MBDHEAD	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW MBDHEAD	;HEADER STRING FROM PROGRAM MEMORY
		CALL	PRMEM
		MOVLW	LOW ECARDEL	;BEACON CARRIER DELAY VALUE FROM EEPROM
		CALL	READEE
		CALL	PHEX		;PRINT VALUE
;
		CALL	PRCRLF		;PRINT CURRENT CHANNEL DATA HEADER
		CALL	PRCRLF
		MOVLW	HIGH ECHEAD	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW ECHEAD	;HEADER STRING FROM PROGRAM MEMORY
		CALL	PRMEM
;
		CALL	GETSWITCH	;GET SWITCH DATA
		MOVFW	SWITCH
		MOVWF	TEMP
		CALL	PHEX		;PRINT CHANNEL NUMBER
		BCF	STATUS,C	;MULTIPLY SWITCH X5
		RLF	TEMP,F
		BCF	STATUS,C
		RLF	TEMP,F
		MOVFW	SWITCH
		ADDWF	TEMP,W		;RESULT NOW IN TEMP
		MOVWF	MEMPOINT		
		MOVLW	D'5'		;5 LOCATIONS TO PRINT
		MOVWF	TEMP
PREELOP		MOVFW	MEMPOINT	;GET EEPROM LOCATION
		CALL	READEE		;READ EEPROM
		CALL	PHEX		;PRINT HEX VALUE
		INCF	MEMPOINT,F	;GOTO NEXT EEPROM LOCATION
		DECF	TEMP,F
		BTFSS	STATUS,Z
		GOTO	PREELOP
;
		CALL	PRCRLF		;PRINT DIAGNOSTICS HEADER
		CALL	PRCRLF
		MOVLW	HIGH DIAGHEAD	;GET HIGH POINTER (TABLE START ADDRESS)
		MOVWF	MEMPOINT	;LOAD POINTER
		MOVLW	LOW DIAGHEAD	;DIAGNOSTICS HEADER STRING FROM PROGRAM MEMORY
		CALL	PRMEM
		CALL	PRCRLF
		CALL	PRCRLF
		RETURN	
;
PRCRLF		MOVLW	00DH		;PRINT CR & LF
		CALL	TXCOMS
		MOVLW	00AH
		CALL	TXCOMS
		RETURN
;
;** PRINT HEX DATA IN WREG 
;
PHEX		CALL	HEX2ASCII	;CONVERT DATA TO ASCII
		MOVFW	R1	
		CALL	TXCOMS		;SEND FIRST DIGIT
		MOVFW	R0
		CALL	TXCOMS		;SEND SECOND DIGIT
		MOVLW	020H		;PUT IN SPACE
		CALL	TXCOMS		
		CLRWDT
		RETURN
;
;** HEX TO ASCII CONVERTOR , ENTER WITH HEX IN W , EXIT WITH ASCII
;** MSB IN R1 & LSB IN R0
;
HEX2ASCII	CLRWDT
		MOVWF	R1		;SAVE DATA
		ANDLW	00FH		;MASK OFF TOP BITS
		MOVWF	R0
		MOVLW	0AH		;CHECK IF DIGIT OR LETTER
		SUBWF	R0,W
		BTFSC	STATUS,C
		GOTO	HEXASIN			
		MOVLW	030H		;DIGIT SO ADD 30H
		ADDWF	R0,1
		GOTO	ASCNIB
HEXASIN		MOVLW	037H		;LETTER SO ADD 37H
		ADDWF	R0,1
ASCNIB		SWAPF	R1,0
		ANDLW	00FH
		MOVWF	R1
		MOVLW	0AH
		SUBWF	R1,W
		BTFSC	STATUS,C
		GOTO	HEXASIM	
		MOVLW	030H
		ADDWF	R1,1
		RETURN
HEXASIM		MOVLW	037H
		ADDWF	R1,1
		RETURN
;
;ASCII TO HEX CONVERTOR, ENTER WITH ASCII IN R1 MSB & R0 LSB
;EXIT WITH HEX IN W
;
ASCII2HEX	MOVFW	R0		;GET LSB BYTE
		BTFSS	R0,4		;CHECK IF LETTER OR NUMBER
		ADDLW	009H		;CORRECT IF WAS NUMBER
		ANDLW	00FH		;MASK OFF TOP BITS	
		MOVWF	R0		;R0 HOLDS BOTTOM NIBBLE
;
		MOVFW	R1		;GET LSB BYTE
		BTFSS	R1,4
		ADDLW	009H		;CORRECT IF REQUIRED
		ANDLW	00FH		;MASK OFF TOP BITS	
		MOVWF	R1
		SWAPF	R1,W
		ADDWF	R0,W		;RESULT NOW IN W
		RETURN
;
;** PRINT EEPROM STRING, W CONTAINS START ADDRESS OF STRING, STRING MUST END IN 000H 
;
PREEPROM	MOVWF	R0		;STORE START ADDRESS
PREEPROML	MOVFW	R0
		CALL	READEE
		BTFSC	STATUS,Z	;CHECK IF DATA IS 000H
		RETURN			;RETURN IF DONE
		CALL	TXCOMS		;PRINT CHARACTER
		INCF	R0,F
		GOTO	PREEPROML	;LOOP
;
;** PRINT STRING FROM PROGRAM MEMORY , W CONTAINS START ADDRESS OF OFFSET FROM START OF STRING TABLE, STRING MUST END IN 000H
;
PRMEM		MOVWF	R0		;STORE START ADDRESS
PRMEML		MOVFW	R0		;GET LSB POINTER
		CALL	READPROG
		BTFSC	STATUS,Z	;CHECK IF FIRST BYTE IS 000H
		RETURN			;RETURN IF DONE
		CALL	TXCOMS
		INCF	R0,F
		GOTO	PRMEML
;
;
;
;** TX DATA ROUTINE ON COMMS PORT , DATA IN W , WAITS TILL PREVIOUS CHARACTER 
;** IS SENT THEN RETURNS.		
;
TXCOMS		NOP
		BANKSEL	TXSTA
		BTFSS	TXSTA,TRMT		
		GOTO	TXCOMS		;WAIT TILL SENT
		BANKSEL	0
		MOVWF	TXREG		;SEND NEW DATA
		CLRWDT
		RETURN		
;
;
;****************************** MEMORY ROUTINES *******************************
;
;READ EEPROM DATA, W CONTAINS ADDRESS ON ENTRY AND DATA ON EXIT
;
READEE		NOP
		BANKSEL	EEADR
		MOVWF 	EEADR 		;Address to read
		BANKSEL	EECON1
		BCF 	EECON1,EEPGD 	;Point to Data memory
		BSF 	EECON1,RD 	;EE Read
		BANKSEL	EEDATA
		MOVF 	EEDATA,W 	;W = EEDATA	
		BANKSEL	0		;BANK0
		RETURN
;
;
;WRITE DATA TO EEPROM , EEPOINT CONTAINS ADDRESS AND W CONTAINS DATA 
;
EEWRITE		NOP
		BANKSEL	EEDATA
		MOVWF	EEDATA		;LOAD DATA
		MOVFW	EEPOINT			
		MOVWF	EEADR		;LOAD ADDRESS LOW BITS
		CLRF	EEADRH		;CLEAR HIGH BITS
		BANKSEL	EECON1
		BCF	EECON1,EEPGD	;POINT TO DATA MEMORY
		BSF	EECON1,WREN	;ENABLE WRITES
		BCF	INTCON,GIE	;DISSABLE INTERRUPTS
		MOVLW	055H
		MOVWF	EECON2
		MOVLW	0AAH
		MOVWF	EECON2
		BSF	EECON1,WR	;REQUIRED SEQUENCE FOR WRITES
		BTFSC	EECON1,WR
		GOTO	$-1		;LOOP TILL WRITE IS COMPLETE
		BCF	EECON1,WREN	;DISABLE WRITES
		BANKSEL	0
		BSF	INTCON,GIE	;RE-ENABLE INTERRUPTS
		RETURN
;
;
;READ PROGRAM MEMORY, W CONTAINS OFFSET FROM MEMPOINT
;ON EXIT W CONTAINS DATA, MEMPOINT MUST BE SET CORRECTLY ON CALL    
;
READPROG	BSF 	STATUS,RP1	
		BCF 	STATUS,RP0 	; Bank 2
		MOVWF 	EEADR 		; LS Byte of Program Address to read
		MOVFW	MEMPOINT	;GET MEMORY PAGE POINTER, MUST BE SET PRIOR TO CALL
		MOVWF 	EEADRH 		; MS Byte of Program Address to read
		BSF 	STATUS,RP0	; Bank 3
		BSF 	EECON1,EEPGD 	; Point to PROGRAM memory
		BSF 	EECON1,RD 	; EE Read
;
		NOP			; Any instructions here are ignored as program
		NOP 			; memory is read in second cycle after BSF EECON1,RD
;
		BCF 	STATUS,RP0 	; Bank 2
		MOVF 	EEDATA,W 	; W = LS Byte of Program EEDATA
		BCF	STATUS,RP1	;BACK TO BANK 0
;
		RETURN
;
;
;
;************************ TONE AND DELAY SUBROUTINES **************************
;** CW SIDE TONE FREQUENCY
CWTDEL		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	003H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;** ADC INPUT SETTLE TIME , 1.5MS APPROX
ADCWAIT		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	003H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;** WAIT SHORT TIME , 100MS APPROX
WAIT		CLRWDT
		MOVLW	001H
		MOVWF	R3
		MOVLW	074H
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;
;** WAIT 1 SECOND ROUTINE
;
WAITONE		CLRWDT
		MOVLW	005H
		MOVWF	R3
		MOVLW	0CFH
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;
;
;** CARRIER DELAY ROUTINE
;
CARRIER		CLRWDT
		MOVLW	050H
		MOVWF	R3
		MOVLW	08FH
		MOVWF	R2
		MOVWF	R1
DELAYC		DECFSZ	R1,1     	;ALL FF IS 19 SECONDS
		GOTO 	DELAYC     	
		DECFSZ	R2,1                    
		GOTO	DELAYC
		CLRWDT
		BTFSC	PORTA,KEYIN	
		RETURN			;ABBORT IF KEY LINE GOES HIGH
		BTFSC	PORTD,PTTIN
		RETURN			;ABBORT IF PTT LINE GOES HIGH
		DECFSZ	R3,1      	;MOST SIGNIFICANT REGISTER
       		GOTO	DELAYC
		CLRWDT
		RETURN
;
;
;** DUMB DELAY SUBROUTINE
;
DELAY		DECFSZ	R1,1     	;ALL FF IS 19 SECONDS
		GOTO 	DELAY     	
		DECFSZ	R2,1                    
		GOTO	DELAY
		CLRWDT
		DECFSZ	R3,1      	;MOST SIGNIFICANT REGISTER
       		GOTO	DELAY
		CLRWDT
		RETURN
;
;** DOT BEEP FM
;
DBEEPFM		NOP
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;MAKE FMTONE AND SIDETONE LOW Z OUTPUT
		BCF	TRISC,FMTONE
		BANKSEL	0
BEPML		MOVLW	038H		;TONE DURATION
        	MOVWF	R3
BEPMD		DECFSZ	R3,F
		GOTO	BEPMHT
		BANKSEL	TRISD
		BSF	TRISC,FMTONE	;MAKE FMTONE AND SIDETONE HI Z
		BSF	TRISD,SIDETONE
		BANKSEL	0
        	RETURN
BEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		BSF	PORTC,FMTONE
		MOVLW	0FEH		;FREQ 
		MOVWF	R1		;COUNT REGISTER
BEPMHLH		NOP
		NOP		
		NOP
		DECFSZ	R1,F
		GOTO	BEPMHLH
		BCF	PORTD,SIDETONE
		BCF	PORTC,FMTONE
		MOVLW	0FEH		;FREQ 
		MOVWF	R1
BEPMHLL		NOP
		NOP
		NOP
		DECFSZ	R1,F
		GOTO	BEPMHLL
		GOTO	BEPMD		;LOOP TILL FINNISHED
;
;** DOT BEEP CW
;
DBEEPCW		NOP
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE	;SIDETONE LOW Z OUTPUT
		BANKSEL	0
CBEPML		MOVLW	038H		;TONE DURATION
        	MOVWF	R3
CBEPMD		DECFSZ	R3,F
		GOTO	CBEPMHT
		BANKSEL	TRISD
		BSF	TRISD,SIDETONE	;MAKE SIDETONE HI Z
		BANKSEL	0
        	RETURN
;
CBEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		MOVLW	0FEH		;FREQ 
		MOVWF	R1		;COUNT REGISTER
CBEPMHLH	NOP
		NOP		
		NOP
		DECFSZ	R1,F
		GOTO	CBEPMHLH
		BCF	PORTD,SIDETONE
		MOVLW	0FEH		;FREQ 
		MOVWF	R1
CBEPMHLL	NOP
		NOP
		NOP
		DECFSZ	R1,F
		GOTO	CBEPMHLL
		GOTO	CBEPMD		;LOOP TILL FINNISHED
;
;
;** GENERATE LOW BEEP TO TX TONES (SHORT LOW BEEP)
;
LBEEP  		CALL	WAIT		;SHORT DELAY BEFORE BEEP
		BANKSEL	TRISD
		BCF	TRISD,SIDETONE
		BCF	TRISC,FMTONE
		BANKSEL	0		;LOW Z SIDETONE AND FMTONE LINES
		BCF	PORTC,FMTONE
		BCF	PORTD,SIDETONE	;RESET AUDIO
LBEPML		MOVLW	040H		;TONE DURATION
        	MOVWF	R3
LBEPMD		DECFSZ	R3,F
		GOTO	LBEPMHT
		BANKSEL	TRISD		;HI Z SIDETONE AND FMTONE LINES
		BSF	TRISD,SIDETONE
		BSF	TRISC,FMTONE
		BANKSEL	0
        	RETURN
LBEPMHT		BSF	PORTD,SIDETONE	;GENERATE AUDIO
		BSF	PORTC,FMTONE
		MOVLW	0F0H		;FREQ 
		MOVWF	R1		;COUNT REGISTER
LBEPMHLH	CLRWDT
		NOP
		DECFSZ	R1,F
		GOTO	LBEPMHLH
		BCF	PORTD,SIDETONE
		BCF	PORTC,FMTONE
		MOVLW	0F0H		;FREQ 
		MOVWF	R1
LBEPMHLL	CLRWDT
		NOP
		DECFSZ	R1,F
		GOTO	LBEPMHLL
		GOTO	LBEPMD		;LOOP TILL FINNISHED
;
;******************************************************************************
;************************ MORSE GENERATION ROUTINES ***************************
;******************************************************************************
;
;** SEND MORSE CODE IDENT STRING
;
MORSEIDENT	MOVLW	LOW IDENTMORSE	;POINT TO START OF IDENT TEXT		
		MOVWF	MORSECH		;STORE START ADDRESS
MREEPROML	MOVFW	MORSECH
		CALL	READEE
		BTFSC	STATUS,Z	;CHECK IF DATA IS 000H
		RETURN			;RETURN IF DONE
		BTFSC	PORTA,KEYIN	
		RETURN			;ABBORT IF KEY LINE GOES HIGH
		BTFSC	PORTD,PTTIN
		RETURN			;ABBORT IF PTT LINE GOES HIGH
		CALL	READMORSE	;LOOK UP MORSE TABLE AND STORE IN DATA REGISTERS
		MOVF	MORSE1,F	;CHECK IF CHARACTER DATA WAS 000H IE SPACE
		BTFSC	STATUS,Z
		CALL	MSPACE		;ADD SPACE IF REQUIRED
		CALL	TXTMORSE	;SEND MORSE CHARACTER FROM DATA, ADDS 1 DOT DELAY ALSO
		CALL	DOTD
		CALL	DOTD		;SPACE BETWEEN CHARACTERS
		INCF	MORSECH,F
		GOTO	MREEPROML	;LOOP
;
MSPACE		CALL	DOTD		;ADD REQUIRED TIME FOR WORD SPACE
		CALL	DOTD
		CALL	DOTD
		CALL	DOTD		
		RETURN
;
;** SEND MORSE CHARACTER FROM LOOKED UP DATA REGISTERS
;
TXTMORSE	BTFSS	MORSE1,7	;LOOK AT FIRST BIT		
		GOTO	CHECKKY
		CALL	DOT		;KEY TX, SEND AUDIO BEEP IF FM
CHECKKY		BTFSC	MORSE1,7		
		GOTO	MORSEDEL
;
;DOT OFF
;
		BCF	PORTD,SIDETONE	;SIDETONE LOW
		CALL	LEDOFF		;PUT LED OFF
		BTFSS	GFLAG,CWON	;CHECK IF DOT WAS CW OR FM
		GOTO	FMDOTFIN
		BCF	GFLAG,CWON	;CLEAR CW ON FLAG
		CALL	SYNTHRX		;END OF CW DOT SO ALWAYS ON RX FREQ HERE
;
FMDOTFIN	CALL	DOTD		;MORSE DOT TIME			
MORSEDEL	MOVLW	B'11000000'	;LOOK AT BIT 7 & 6 ONLY
		ANDWF	MORSE1,W
		BTFSC	STATUS,Z	;CHECK IF FINNISHED
		RETURN			;END IF DONE
		BCF	STATUS,C	;CLEAR CARRY
		RLF	MORSE3,F	;ROTATE DATA TO GET NEXT BIT
		RLF	MORSE2,F
		RLF	MORSE1,F		
		GOTO	TXTMORSE	;LOOP TILL DONE
;
;DOT DELAY
;
DOTD		MOVLW	LOW EWPM	;DOT DELAY DURING PAUSES (RX TIME)
		CALL	READEE		;GET WPM DATA HIGH BYTE
		MOVWF	R3
		MOVLW	LOW (EWPM+1)	;GET WPM DATA LOW BYTE
		CALL	READEE
		MOVWF	R2
		MOVWF	R1
		CALL	DELAY
		RETURN
;
;DOT ON (SEND)
;
DOT		BTFSC	PORTB,CH0	;CHECK IF CW OR FM MODE	
		GOTO	DOTCW		
;
DOTFM		CALL	LEDRED
		CALL	DBEEPFM		;USE TONE GENERATION ROUTINE
		RETURN
;
DOTCW		BTFSC	GFLAG,CWON
		GOTO	DOTCWON
		BSF	GFLAG,CWON	;SET FLAG TO SHOW CW KEY IS ON
		CALL	SYNTHTX		;TX FREQ TO SEND CW
DOTCWON		CALL	LEDRED
		CALL	DBEEPCW
		RETURN
;
;READ PROGRAM MEMORY CONTAINING MORSE CHARACTER DATA
;W CONTAINS OFFSET FROM MORSE TABLE START EQUAL TO ASCII VALUE
;SPECIAL CASES OF ASCII SPACE, "/" AND UN-USED ARE RE-ASSIGNED AS REQUIRED
;
READMORSE	MOVWF	R1		;TEMP STORAGE OF START POINTER
		SUBLW	020H		;TRAP FOR SPACE
		MOVLW	00AH		;PRE-INSERT SPACE
		BTFSC	STATUS,Z
		GOTO	READMORNW
		MOVFW	R1		;GET START POINT BACK
		SUBLW	02FH		;TRAP FOR "/"
		MOVLW	010H		;PRE-INSERT "/"
		BTFSC	STATUS,Z
		GOTO	READMORNW
		BTFSC	R1,6		;CHECK IF LETTER OR NUMBER/CONTROL
		BCF	R1,5		;ENSURE ALWAYS UPPER CASE ASCII ONLY IF LETTER
		MOVLW	030H
		SUBWF	R1,W		;CONVERT ASCII TO HEX ADDRESS
		BTFSS	STATUS,C	;CHECK IF CARRY, IE CHARACTER UN-USED LESS THAN 030H
		MOVLW	00AH		;USE SPACE LOCATION IF LOW CHARACTER
READMORNW	MOVWF	R1
		ADDWF	R1,W		;MULTIPLY BY 3 TO GET CORRECT START POINT IN TABLE
		ADDWF	R1,W
		MOVWF	R1
		CALL	READMORL
		MOVWF	MORSE1
		INCF	R1,F
		MOVFW	R1
		CALL	READMORL
		MOVWF	MORSE2
		INCF	R1,F
		MOVFW	R1
		CALL	READMORL
		MOVWF	MORSE3
		RETURN		
;
READMORL	NOP
		BANKSEL	EEADR		; Bank 2
		MOVWF 	EEADR 		; LS Byte of Program Address to read
		MOVLW 	HIGH MORSETAB	; MORSE STRINGS ALWAYS START AT MORSETAB STRING
		MOVWF 	EEADRH 		; MS Byte of Program Address to read
		BANKSEL	EECON1		; Bank 3
		BSF 	EECON1,EEPGD 	; Point to PROGRAM memory
		BSF 	EECON1,RD 	; EE Read
;
		NOP			; Any instructions here are ignored as program
		NOP 			; memory is read in second cycle after BSF EECON1,RD
;
		BANKSEL	EEDATA	 	; Bank 2
		MOVF 	EEDATA,W 	; W = LS Byte of Program EEDATA
		BANKSEL	PORTA		;BACK TO BANK 0
;
		RETURN
;
;******************************************************************************
;**************************** MORSE TABLE *************************************
;******************************************************************************
;
		ORG	00D00H		;START ADDRESS OF MORSE TABLE
;
;3 BYTES PER CHARACTER (24 BITS)
;OFFSET TO ALLOW DIRECT ASCII LOOKUP, IE 0 MORSE = ASCII 030H
;
MORSETAB	DE	B'11101110',B'11101110',B'11100000'	;MORSE 0 = ASCII 30
		DE	B'10111011',B'10111011',B'10000000'	;1
		DE	B'10101110',B'11101110',B'00000000'	;2
		DE	B'10101011',B'11011100',B'00000000'	;3
		DE	B'10101010',B'11100000',B'00000000'	;4
		DE	B'10101010',B'10000000',B'00000000'	;5
		DE	B'11101010',B'10100000',B'00000000'	;6
		DE	B'11101110',B'10101000',B'00000000'	;7
		DE	B'11101110',B'11101010',B'00000000'	;8
		DE	B'11101110',B'11101110',B'10000000'	;9
		DE	B'00000000',B'00000000',B'00000000'	;MORSE 0A = ASCII 03A (RE-ASSIGNED TO SPACE ASCII 020H, SPECIAL CASE ALL 0'S) 
		DE	B'00000000',B'00000000',B'00000000'	;(ALL UN-USED LOCATIONS ARE DEFAULTED TO SPACE)
		DE	B'00000000',B'00000000',B'00000000'	;
		DE	B'00000000',B'00000000',B'00000000'	;
		DE	B'00000000',B'00000000',B'00000000'	;
		DE	B'00000000',B'00000000',B'00000000'	;
		DE	B'11101010',B'11101000',B'00000000'	;MORSE 010 = ASCII 040H (RE-ASSIGNED TO FORWARD SLASH / ASCII 02FH )
		DE	B'10111000',B'00000000',B'00000000'	;A = ASCII 041H
		DE	B'11101010',B'10000000',B'00000000'	;B
		DE	B'11101011',B'10100000',B'00000000'	;C
		DE	B'11101010',B'00000000',B'00000000'	;D
		DE	B'10000000',B'00000000',B'00000000'	;E
		DE	B'10101110',B'10000000',B'00000000'	;F
		DE	B'11101110',B'10000000',B'00000000'	;G
		DE	B'10101010',B'00000000',B'00000000'	;H
		DE	B'10100000',B'00000000',B'00000000'	;I
		DE	B'10111011',B'10111000',B'00000000'	;J
		DE	B'11101011',B'10000000',B'00000000'	;K
		DE	B'10111010',B'10000000',B'00000000'	;L
		DE	B'11101110',B'00000000',B'00000000'	;M
		DE	B'11101000',B'00000000',B'00000000'	;N
		DE	B'11101110',B'11100000',B'00000000'	;O
		DE	B'10111011',B'10100000',B'00000000'	;P
		DE	B'11101110',B'10111000',B'00000000'	;Q
		DE	B'10111010',B'00000000',B'00000000'	;R
		DE	B'10101000',B'00000000',B'00000000'	;S
		DE	B'11100000',B'00000000',B'00000000'	;T
		DE	B'10101110',B'00000000',B'00000000'	;U
		DE	B'10101011',B'10000000',B'00000000'	;V
		DE	B'10111011',B'10000000',B'00000000'	;W
		DE	B'11101010',B'11100000',B'00000000'	;X
		DE	B'11101011',B'10111000',B'00000000'	;Y
		DE	B'11101110',B'10100000',B'00000000'	;Z = ASCII 05AH
;
;
;******************************************************************************
;*************************** TEXT STRINGS *************************************
;******************************************************************************
;
		ORG	01000H	 	;PAGE 1 START ADDRESS OF TEXT STRINGS (EACH PAGE 256 BYTES MAX)
;
TXTBOOT		DE	"** 241-250GHz_001 VK3CV / WQ1S **",000H
;
SERIAL		DE	" VERSION # ",VERSION,000H	;SEE START OF CODE FOR VERSION DEFINITION
;
CALLHEAD	DE	" BEACON = ",000H
;
DIAGHEAD	DE	" ER  TU  REFV EC VCOV DCIN CPWR CTMP ",000H
;
PLLERRT		DE	" PLL LOCK ERROR ",00DH,000H
;
LOWDCERRT	DE	" LOW DCin ERROR ",00DH,000H
;
NOERROR		DE	"                        ",000H
;
GPSSTRING	DE	008H,008H,008H,008H,"GPS",000H
;
COMPROMPT	DE	00DH,"                                            ",00DH," COMMAND ? >_ ",000H
;
		ORG	01100H		;PAGE 2 OF TEXT STRINGS
;
COMERROR	DE	007H,00DH," COMMAND ERROR ",000H
;
COMOK		DE	00DH,00AH," COMMAND OK ",000H
;
MBDHEAD		DE	" BEACON CARRIER DELAY = ",000H
;
ECHEAD		DE	" CURRENT CHANNEL DATA = CH",000H
;
M10STRING	DE	008H,008H,008H,008H,"10MHz",000H
;
;******************************************************************************
;**************** SYNTHESIZER INITIALIZATION DATA VALUES **********************
;******************************************************************************
;
;
		ORG	01200H			;START ADDRESS OF PLL INITIALIZATION 
;
;ADF41513 INITIALIZE AND ENABLE SYNTH FOR NORMAL OPERATION 134,000.1 MHz
;
SYNTHEN		DE	000H,000H,000H,00DH	;REG 13 VALUES
		DE	068H,000H,000H,00CH	;REG 12 VALUES
		DE	000H,000H,000H,00BH	;REG 11 VALUES
		DE	000H,000H,000H,00AH	;REG 10 VALUES
		DE	000H,000H,000H,009H	;REG 9 VALUES
		DE	000H,000H,000H,008H	;REG 8 VALUES
		DE	000H,020H,004H,007H	;REG 7 VALUES
		DE	048H,040H,000H,086H	;REG 6 VALUES (POWER UP)
		DE	05EH,041H,000H,005H	;REG 5 VALUES
		DE	000H,000H,000H,004H	;REG 4 VALUES
		DE	000H,000H,000H,003H	;REG 3 VALUES
		DE	000H,000H,000H,012H	;REG 2 VALUES
		DE	01EH,039H,01DH,0D1H	;REG 1 VALUES (THIS IS MAIN FREQUENCY CONTROL)
		DE	000H,000H,004H,020H	;REG 0 VALUES HIGH BAND (THIS BYTE MUST ALWAYS BE WRITTEN LAST TO LATCH DATA INTO CHIP)
;
;
;ADF41513 DISSABLE SYNTH FOR RESET
;
SYNTHDIS	DE	000H,000H,000H,00DH	;REG 13 VALUES
		DE	068H,000H,000H,00CH	;REG 12 VALUES
		DE	000H,000H,000H,00BH	;REG 11 VALUES
		DE	000H,000H,000H,00AH	;REG 10 VALUES
		DE	000H,000H,000H,009H	;REG 9 VALUES
		DE	000H,000H,000H,008H	;REG 8 VALUES
		DE	000H,020H,004H,007H	;REG 7 VALUES
		DE	048H,040H,000H,0C6H	;REG 6 VALUES (POWER DOWN)
		DE	05EH,041H,000H,005H	;REG 5 VALUES
		DE	000H,000H,000H,004H	;REG 4 VALUES
		DE	000H,000H,000H,003H	;REG 3 VALUES
		DE	000H,000H,000H,012H	;REG 2 VALUES
		DE	01EH,039H,01DH,0D1H	;REG 1 VALUES
		DE	000H,000H,004H,020H	;REG 0 VALUES
;
;
;
;******************************************************************************
; DEFAULT VALUES FOR FREQUENCY TABLE STORED HERE	
;******************************************************************************
;
#DEFINE	FDATA0	042H,01EH,039H,01DH,0D1H	;CH0 SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;						
;
#DEFINE	FDATA1	0C2H,01FH,081H,006H,021H	;CH1 SYNTH FREQUENCY DATA (241,144.200 MHz)(TPLO = 3349.2250000 MHz)
;						
;					
#DEFINE FDATA2	0C4H,001H,0C7H,01CH,071H	;CH2 SYNTH FREQUENCY DATA (245,000.000 MHz)(TPLO = 3402.7777777 MHz)
;						
;
#DEFINE FDATA3	044H,000H,07FH,034H,021H	;CH3 SYNTH FREQUENCY DATA (244,855.900 MHz)(TPLO = 3400.7763889 MHz)
;					
;
#DEFINE FDATA4	0C4H,01CH,071H,0C7H,021H	;CH4 SYNTH FREQUENCY DATA (248,000.000 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATA5	044H,01BH,029H,0DEH,0C1H	;CH5 SYNTH FREQUENCY DATA (247,855.900 MHz)(TPLO = 3442.4430556 MHz)
;
;
#DEFINE FDATA6	0C5H,00EH,038H,0E3H,091H	;CH6 SYNTH FREQUENCY DATA (250,000.000 MHz)(TPLO = 3472.2222222 MHz)
;						
;
#DEFINE FDATA7	045H,00CH,0F0H,0FBH,041H	;CH7 SYNTH FREQUENCY DATA (249,855.900 MHz)(TPLO = 3470.2208333 MHz)
;					
;
#DEFINE FDATA8	042H,01EH,039H,01DH,0D1H	;CH8 SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATA9	042H,01EH,039H,01DH,0D1H	;CH9 SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAA	042H,01EH,039H,01DH,0D1H	;CHA SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAB	042H,01EH,039H,01DH,0D1H	;CHB SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAC	042H,01EH,039H,01DH,0D1H	;CHC SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAD	042H,01EH,039H,01DH,0D1H	;CHD SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAE	042H,01EH,039H,01DH,0D1H	;CHE SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;
#DEFINE FDATAF	042H,01EH,039H,01DH,0D1H	;CHF SYNTH FREQUENCY DATA (241,000.100 MHz)(TPLO = 3347.2236111 MHz)
;
;******************************************************************************
;
		ORG	01300H		;USE THIS FOR STORAGE OF FACTORY DEFAULT CHANNEL DATA VALUES
;
DEFFDATA0	DE	FDATA0		;SET UP DEFAULT ARRAY OF CHANNEL DATA IN PROGRAM MEMORY
		DE	FDATA1
		DE	FDATA2
		DE	FDATA3
		DE	FDATA4
		DE	FDATA5
		DE	FDATA6
		DE	FDATA7
		DE	FDATA8
		DE	FDATA9
		DE	FDATAA
		DE	FDATAB
		DE	FDATAC
		DE	FDATAD
		DE	FDATAE
		DE	FDATAF
;
;******************************************************************************
;************************** EEPROM INITIALIZATION *****************************
;******************************************************************************
;
;******************************************************************************
; EEPROM CHANNEL FREQUENCY TABLE
;******************************************************************************
;
		ORG	02100H		;LOAD EEPROM VALUES FOR SYNTH CHANNELS 
;
FREQ0		DE	FDATA0		;SET UP DEFAULT ARRAY OF CHANNEL DATA IN EEPROM MEMORY
		DE	FDATA1
		DE	FDATA2
		DE	FDATA3
		DE	FDATA4
		DE	FDATA5
		DE	FDATA6
		DE	FDATA7
		DE	FDATA8
		DE	FDATA9
		DE	FDATAA
		DE	FDATAB
		DE	FDATAC
		DE	FDATAD
		DE	FDATAE
		DE	FDATAF
;
;******************************************************************************
;EEPROM DATA STORAGE TABLE
;******************************************************************************
;
		ORG	021E0H				;START OF EEPROM DATA STORAGE
;
ERTUNEL		DE	032H				;(032H NOMINAL) REFERENCE TUNE VALUE LOW BITS
;
ERTUNEH		DE	0BEH				;(0BEH NOMINAL) REFERENCE TUNE VALUE HIGH BITS
;
EWPM		DE	001H,0FAH			;MORSE CW BEACON WPM (01FA = APPROX 15 WPM)
;
ECARDEL		DE	01EH				;MORSE BEACON CARRIER DELAY IN SECONDS (01EH = 30 SECONDS)
;
		ORG	21E6H				;MORSE BEACON STRING EEPROM START ADDRESS
;
IDENTMORSE	DE	"de VK3CV/WQ1S QF22ma",000H	;MORSE BEACON IDENT (UPPER OR LOWER CASE, 24 CHARACTER MAX)
;							;LETTERS, NUMBERS, SPACES AND / ONLY.
		ORG	21FFH		
;		
		DE	000H				;FORCE END OF TABLE ALWAYS TO 000H TO END 
;
		END	;(BON-E-HOH)
